/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.ai.EntityAIBunnyReproduce;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIFollowAdult;
import drzhark.mocreatures.entity.ai.EntityAIFollowOwnerPlayer;
import drzhark.mocreatures.entity.ai.EntityAIPanicMoC;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityBunny
extends MoCEntityTameableAnimal {
    private static final DataParameter<Boolean> HAS_EATEN = EntityDataManager.func_187226_a(MoCEntityBunny.class, (DataSerializer)DataSerializers.field_187198_h);
    public int bunnyReproduceTickerA;
    public int bunnyReproduceTickerB;
    private int jumpTimer;

    public MoCEntityBunny(World world) {
        super(world);
        this.setAdult(true);
        this.setTamed(false);
        this.setAge(50 + this.func_70681_au().nextInt(15));
        if (this.func_70681_au().nextInt(4) == 0) {
            this.setAdult(false);
        }
        this.func_70105_a(0.5f, 0.5f);
        this.bunnyReproduceTickerA = this.func_70681_au().nextInt(64);
        this.bunnyReproduceTickerB = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwnerPlayer((EntityLiving)this, 0.8, 6.0f, 5.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanicMoC((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.0, 4.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowAdult((EntityLiving)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIBunnyReproduce(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_EATEN, (Object)false);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData entityLivingData) {
        if (this.field_70170_p.field_73011_w.getDimension() == MoCreatures.proxy.wyvernDimension) {
            this.func_110163_bv();
        }
        return super.func_180482_a(difficulty, entityLivingData);
    }

    @Override
    public boolean getHasEaten() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EATEN);
    }

    @Override
    public void setHasEaten(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_EATEN, (Object)flag);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.func_70681_au().nextInt(5) + 1);
        }
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(3);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 2: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_beige.png") : MoCreatures.proxy.getModelTexture("bunny_beige_detailed.png");
            }
            case 3: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_white.png") : MoCreatures.proxy.getModelTexture("bunny_white_detailed.png");
            }
            case 4: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_black.png") : MoCreatures.proxy.getModelTexture("bunny_black_detailed.png");
            }
            case 5: {
                return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_spotted.png") : MoCreatures.proxy.getModelTexture("bunny_spotted_detailed.png");
            }
        }
        return MoCreatures.proxy.legacyBunnyTextures ? MoCreatures.proxy.getModelTexture("bunny_golden.png") : MoCreatures.proxy.getModelTexture("bunny_golden_detailed.png");
    }

    public void func_180430_e(float f, float f1) {
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_BUNNY_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_BUNNY_HURT;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.BUNNY;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == Items.field_151172_bF && !this.getHasEaten()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.setHasEaten(true);
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_GENERIC_EAT);
                if (!this.getIsTamed() && !this.field_70170_p.field_72995_K) {
                    MoCTools.tameWithName(player, this);
                }
                return true;
            }
        } else if (this.func_184187_bx() == null) {
            if (this.startRidingPlayer(player)) {
                this.field_70177_z = player.field_70177_z;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (!this.field_70170_p.field_72995_K && --this.jumpTimer <= 0 && this.field_70122_E && (this.field_70159_w > 0.05 || this.field_70179_y > 0.05 || this.field_70159_w < -0.05 || this.field_70179_y < -0.05)) {
            this.field_70181_x = 0.3;
            this.jumpTimer = 15;
        }
    }

    @Override
    public int nameYOffset() {
        return -40;
    }

    @Override
    public boolean isMyHealFood(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151172_bF;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.func_184187_bx() != null) {
            return false;
        }
        return super.func_70097_a(damagesource, i);
    }

    @Override
    public boolean isNotScared() {
        return this.getIsTamed();
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer) {
            return this.func_184187_bx().func_70093_af() ? 0.25 : 0.5;
        }
        return super.func_70033_W();
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.2f;
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.675f;
    }

    @Override
    public boolean isReadyToFollowOwnerPlayer() {
        return !this.isMovementCeased();
    }
}

