/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.passive;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityAnimal;
import drzhark.mocreatures.entity.ai.EntityAIFleeFromPlayer;
import drzhark.mocreatures.entity.ai.EntityAIWanderMoC2;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityMouse
extends MoCEntityAnimal {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(MoCEntityMouse.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityMouse(World world) {
        super(world);
        this.func_70105_a(0.45f, 0.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFleeFromPlayer((EntityCreature)this, 1.2, 4.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderMoC2((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)Boolean.FALSE);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            this.setType(this.field_70146_Z.nextInt(3) + 1);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("mouse_brown.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("mouse_white.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("mouse_beige.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                this.setType(2);
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean getIsPicked() {
        return this.func_184187_bx() != null;
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_MOUSE_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_MOUSE_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCSoundEvents.ENTITY_MOUSE_AMBIENT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MoCLootTables.MOUSE;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    public void func_180430_e(float f, float f1) {
    }

    public double func_70033_W() {
        if (this.func_184187_bx() instanceof EntityPlayer && this.func_184187_bx() == MoCreatures.proxy.getPlayer() && this.field_70170_p.field_72995_K) {
            return super.func_70033_W() - (double)0.7f;
        }
        if (this.func_184187_bx() instanceof EntityPlayer && this.field_70170_p.field_72995_K) {
            return super.func_70033_W() - (double)0.1f;
        }
        return super.func_70033_W();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_184187_bx() == null) {
            if (this.startRidingPlayer(player)) {
                this.field_70177_z = player.field_70177_z;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
    }

    public boolean upsideDown() {
        return this.getIsPicked();
    }

    @Override
    public boolean canRidePlayer() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.575f;
    }
}

