/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.tameable;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class MoCPetMapData
extends WorldSavedData {
    private final Object2ObjectOpenHashMap<UUID, MoCPetData> petMap = new Object2ObjectOpenHashMap();

    public MoCPetMapData(String par1Str) {
        super(par1Str);
        this.func_76185_a();
    }

    public MoCPetData getPetData(UUID ownerUniqueId) {
        return (MoCPetData)this.petMap.get((Object)ownerUniqueId);
    }

    public Object2ObjectOpenHashMap<UUID, MoCPetData> getPetMap() {
        return this.petMap;
    }

    public void removeOwnerPet(IMoCTameable pet, int petId) {
        UUID owner = pet.getOwnerId();
        if (this.petMap.get((Object)owner) != null && ((MoCPetData)this.petMap.get((Object)owner)).removePet(petId)) {
            this.func_76185_a();
            pet.setOwnerPetId(-1);
        }
    }

    public void updateOwnerPet(IMoCTameable pet) {
        this.func_76185_a();
        if (pet.getOwnerPetId() == -1 || this.petMap.get((Object)pet.getOwnerId()) == null) {
            int id;
            UUID owner;
            UUID uUID = owner = MoCreatures.isServer() ? pet.getOwnerId() : Minecraft.func_71410_x().field_71439_g.func_110124_au();
            if (this.petMap.containsKey((Object)owner)) {
                MoCPetData petData = (MoCPetData)this.petMap.get((Object)owner);
                id = petData.addPet(pet);
            } else {
                MoCPetData petData = new MoCPetData(pet);
                id = petData.addPet(pet);
                this.petMap.put((Object)owner, (Object)petData);
            }
            pet.setOwnerPetId(id);
        } else {
            UUID owner = pet.getOwnerId();
            MoCPetData petData = this.getPetData(owner);
            NBTTagCompound rootNBT = petData.getOwnerRootNBT();
            NBTTagList tag = rootNBT.func_150295_c("TamedList", 10);
            int id = pet.getOwnerPetId();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                if (nbt.func_74762_e("PetId") != id) continue;
                nbt.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList(((Entity)pet).field_70165_t, ((Entity)pet).field_70163_u, ((Entity)pet).field_70161_v));
                nbt.func_74768_a("ChunkX", ((Entity)pet).field_70176_ah);
                nbt.func_74768_a("ChunkY", ((Entity)pet).field_70162_ai);
                nbt.func_74768_a("ChunkZ", ((Entity)pet).field_70164_aj);
                nbt.func_74768_a("Dimension", ((Entity)pet).field_70170_p.field_73011_w.func_186058_p().func_186068_a());
                nbt.func_74768_a("PetId", pet.getOwnerPetId());
            }
        }
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d1 : par1ArrayOfDouble) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    public boolean isExistingPet(UUID owner, IMoCTameable pet) {
        MoCPetData petData = MoCreatures.instance.mapData.getPetData(owner);
        if (petData != null) {
            NBTTagList tag = petData.getTamedList();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                if (nbt.func_74762_e("PetId") != pet.getOwnerPetId()) continue;
                return true;
            }
        }
        return false;
    }

    public void forceSave() {
        if (DimensionManager.getWorld((int)0) != null) {
            ISaveHandler saveHandler = DimensionManager.getWorld((int)0).func_72860_G();
            try {
                File file1 = saveHandler.func_75758_b("mocreatures");
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                this.func_189551_b(nbttagcompound);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74782_a("data", (NBTBase)nbttagcompound);
                FileOutputStream fileoutputstream = new FileOutputStream(file1);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void func_76184_a(NBTTagCompound par1NBTTagCompound) {
        for (String s : par1NBTTagCompound.func_150296_c()) {
            NBTTagCompound nbt = (NBTTagCompound)par1NBTTagCompound.func_74781_a(s);
            UUID ownerUniqueId = UUID.fromString(s);
            if (this.petMap.containsKey((Object)ownerUniqueId)) continue;
            this.petMap.put((Object)ownerUniqueId, (Object)new MoCPetData(nbt, ownerUniqueId));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound par1NBTTagCompound) {
        for (Map.Entry ownerEntry : this.petMap.entrySet()) {
            try {
                if (ownerEntry.getKey() == null) continue;
                par1NBTTagCompound.func_74782_a(((UUID)ownerEntry.getKey()).toString(), (NBTBase)((MoCPetData)ownerEntry.getValue()).getOwnerRootNBT());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return par1NBTTagCompound;
    }
}

