/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.event;

import com.google.common.primitives.Ints;
import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.MoCEntityData;
import drzhark.mocreatures.entity.neutral.MoCEntityKitty;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetMapData;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class MoCEventHooks {
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_73011_w.func_186058_p().func_186068_a() == 0) {
            MoCreatures.proxy.worldInitDone = false;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (DimensionManager.getWorld((int)0) != null && !MoCreatures.proxy.worldInitDone) {
            MoCPetMapData data = (MoCPetMapData)DimensionManager.getWorld((int)0).func_175693_T().func_75742_a(MoCPetMapData.class, "mocreatures");
            if (data == null) {
                data = new MoCPetMapData("mocreatures");
            }
            DimensionManager.getWorld((int)0).func_175693_T().func_75745_a("mocreatures", (WorldSavedData)data);
            DimensionManager.getWorld((int)0).func_175693_T().func_75744_a();
            MoCreatures.instance.mapData = data;
            MoCreatures.proxy.worldInitDone = true;
        }
    }

    @SubscribeEvent
    public void onPopulateVillage(PopulateChunkEvent.Post event) {
        if (event.isHasVillageGenerated()) {
            MoCEntityData data = (MoCEntityData)MoCreatures.entityMap.get(MoCEntityKitty.class);
            if (data == null) {
                return;
            }
            World world = event.getWorld();
            List dimensionIDs = Ints.asList((int[])data.getDimensions());
            if (!data.getCanSpawn() || data.getFrequency() <= 0 || !dimensionIDs.contains(world.field_73011_w.getDimension())) {
                return;
            }
            if (event.getRand().nextInt(100) < MoCreatures.proxy.kittyVillageChance) {
                MoCEntityKitty kitty = new MoCEntityKitty(world);
                BlockPos pos = new BlockPos(event.getChunkX() * 16, 100, event.getChunkZ() * 16);
                BlockPos spawnPos = this.getSafeSpawnPos((EntityLivingBase)kitty, pos.func_177982_a(8, 0, 8));
                if (spawnPos == null || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)spawnPos)) {
                    return;
                }
                kitty.func_180482_a(world.func_175649_E(new BlockPos((Entity)kitty)), null);
                kitty.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
                if (!kitty.func_70601_bi()) {
                    return;
                }
                world.func_72838_d((Entity)kitty);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Class<?> entityClass = entity.getClass();
        MoCEntityData data = (MoCEntityData)MoCreatures.entityMap.get(entityClass);
        if (data == null) {
            return;
        }
        World world = event.getWorld();
        List dimensionIDs = Ints.asList((int[])data.getDimensions());
        if (!dimensionIDs.contains(world.field_73011_w.getDimension())) {
            event.setResult(Event.Result.DENY);
        } else if (data.getFrequency() <= 0) {
            event.setResult(Event.Result.DENY);
        } else if (dimensionIDs.contains(MoCreatures.proxy.wyvernDimension) && world.field_73011_w.getDimension() == MoCreatures.proxy.wyvernDimension) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && IMoCTameable.class.isAssignableFrom(event.getEntityLiving().getClass())) {
            IMoCTameable mocEntity = (IMoCTameable)event.getEntityLiving();
            if (mocEntity.getIsTamed() && mocEntity.getPetHealth() > 0.0f && !mocEntity.isRiderDisconnecting()) {
                return;
            }
            if (mocEntity.getOwnerPetId() != -1) {
                MoCreatures.instance.mapData.removeOwnerPet(mocEntity, mocEntity.getOwnerPetId());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        IMoCEntity mocEntity;
        Entity entityRidingPlayer;
        EntityPlayer player = event.player;
        if (player.func_184187_bx() instanceof IMoCTameable) {
            IMoCTameable mocEntity2 = (IMoCTameable)player.func_184187_bx();
            mocEntity2.setRiderDisconnecting(true);
        }
        if ((entityRidingPlayer = MoCTools.getEntityRidingPlayer(player)) != null && IMoCEntity.class.isAssignableFrom(entityRidingPlayer.getClass()) && (mocEntity = (IMoCEntity)entityRidingPlayer).canRidePlayer()) {
            MoCTools.dismountPassengerFromEntity(entityRidingPlayer, (Entity)player, true);
        }
    }

    private BlockPos getSafeSpawnPos(EntityLivingBase entity, BlockPos near) {
        int radius = 6;
        int maxTries = 24;
        for (int i = 0; i < maxTries; ++i) {
            int x = near.func_177958_n() + entity.func_130014_f_().field_73012_v.nextInt(radius * 2) - radius;
            int z = near.func_177952_p() + entity.func_130014_f_().field_73012_v.nextInt(radius * 2) - radius;
            int y = entity.func_130014_f_().func_189649_b(x, z) + 16;
            BlockPos testing = new BlockPos(x, y, z);
            while (entity.func_130014_f_().func_175623_d(testing) && testing.func_177956_o() > 0) {
                testing = testing.func_177979_c(1);
            }
            IBlockState iblockstate = entity.func_130014_f_().func_180495_p(testing);
            if (!iblockstate.func_189884_a((Entity)entity)) continue;
            return testing.func_177981_b(1);
        }
        return null;
    }
}

