/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.dimension.MoCDirectTeleporter;
import drzhark.mocreatures.item.MoCItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class ItemStaffPortal
extends MoCItem {
    private int portalPosX;
    private int portalPosY;
    private int portalPosZ;
    private int portalDimension;

    public ItemStaffPortal(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77656_e(3);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean hasUnbreaking;
        ItemStack stack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        boolean hasMending = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) > 0;
        boolean bl = hasUnbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack) > 0;
        if (hasMending || hasUnbreaking) {
            String enchantments = "unbreaking";
            if (hasMending && hasUnbreaking) {
                enchantments = "mending, unbreaking";
            } else if (hasMending) {
                enchantments = "mending";
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation(MoCreatures.MOC_LOGO + TextFormatting.RED + " Detected illegal enchantment(s) '" + TextFormatting.GREEN + enchantments + TextFormatting.RED + "' on Staff Portal!\nThe item has been removed from your inventory.", new Object[0]));
            player.field_71071_by.func_184437_d(stack);
            return EnumActionResult.SUCCESS;
        }
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = stack.func_77978_p();
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (player.func_184187_bx() != null || player.func_184207_aI()) {
            return EnumActionResult.FAIL;
        }
        if (player.field_71093_bK != MoCreatures.wyvernSkylandsDimensionID) {
            this.portalDimension = player.field_71093_bK;
            this.portalPosX = (int)player.field_70165_t;
            this.portalPosY = (int)player.field_70163_u;
            this.portalPosZ = (int)player.field_70161_v;
            this.writeToNBT(nbtcompound);
            BlockPos var2 = playerMP.func_184102_h().func_71218_a(MoCreatures.wyvernSkylandsDimensionID).func_180504_m();
            if (var2 != null) {
                playerMP.field_71135_a.func_147364_a((double)var2.func_177958_n(), (double)var2.func_177956_o(), (double)var2.func_177952_p(), 0.0f, 0.0f);
            }
            playerMP.func_184102_h().func_184103_al().transferPlayerToDimension(playerMP, MoCreatures.wyvernSkylandsDimensionID, (Teleporter)new MoCDirectTeleporter(playerMP.func_184102_h().func_71218_a(MoCreatures.wyvernSkylandsDimensionID)));
            stack.func_77972_a(1, (EntityLivingBase)player);
        } else {
            if (!FMLLaunchHandler.isDeobfuscatedEnvironment() && (player.field_70165_t > 1.5 || player.field_70165_t < -1.5 || player.field_70161_v > 2.5 || player.field_70161_v < -2.5)) {
                return EnumActionResult.FAIL;
            }
            this.readFromNBT(nbtcompound);
            boolean foundSpawn = false;
            if (this.portalPosX == 0 && this.portalPosY == 0 && this.portalPosZ == 0) {
                BlockPos var2 = playerMP.func_184102_h().func_71218_a(0).func_175694_M();
                for (int i1 = 0; i1 < 60; ++i1) {
                    IBlockState blockstate = playerMP.func_184102_h().func_71218_a(0).func_180495_p(pos.func_177982_a(0, i1, 0));
                    IBlockState blockstate1 = playerMP.func_184102_h().func_71218_a(0).func_180495_p(pos.func_177982_a(0, i1 + 1, 0));
                    if (blockstate.func_177230_c() != Blocks.field_150350_a || blockstate1.func_177230_c() != Blocks.field_150350_a) continue;
                    playerMP.field_71135_a.func_147364_a((double)var2.func_177958_n(), (double)var2.func_177956_o() + (double)i1 + 1.0, (double)var2.func_177952_p(), 0.0f, 0.0f);
                    if (MoCreatures.proxy.debug) {
                        System.out.println("MoC Staff teleporter found location at spawn");
                    }
                    foundSpawn = true;
                    break;
                }
                if (!foundSpawn) {
                    if (MoCreatures.proxy.debug) {
                        System.out.println("MoC Staff teleporter couldn't find an adequate teleport location at spawn");
                    }
                    return EnumActionResult.FAIL;
                }
            } else {
                playerMP.field_71135_a.func_147364_a((double)this.portalPosX, (double)this.portalPosY + 1.0, (double)this.portalPosZ, 0.0f, 0.0f);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            playerMP.func_184102_h().func_184103_al().transferPlayerToDimension(playerMP, this.portalDimension, (Teleporter)new MoCDirectTeleporter(playerMP.func_184102_h().func_71218_a(0)));
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BLOCK;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.portalPosX = nbt.func_74762_e("portalPosX");
        this.portalPosY = nbt.func_74762_e("portalPosY");
        this.portalPosZ = nbt.func_74762_e("portalPosZ");
        this.portalDimension = nbt.func_74762_e("portalDimension");
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("portalPosX", this.portalPosX);
        nbt.func_74768_a("portalPosY", this.portalPosY);
        nbt.func_74768_a("portalPosZ", this.portalPosZ);
        nbt.func_74768_a("portalDimension", this.portalDimension);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }
}

