/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.neutral.MoCEntityWyvern;
import drzhark.mocreatures.entity.passive.MoCEntityHorse;
import drzhark.mocreatures.entity.tameable.MoCEntityTameableAnimal;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.item.MoCItem;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAppear;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoCItemHorseAmulet
extends MoCItem {
    private int ageCounter;
    private String name;
    private float health;
    private int age;
    private int creatureType;
    private String spawnClass;
    private boolean isGhost;
    private boolean rideable;
    private byte armor;
    private boolean adult;
    private UUID ownerUniqueId;
    private String ownerName;
    private int PetId;

    public MoCItemHorseAmulet(String name) {
        super(name);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.ageCounter = 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        block28: {
            stack = player.func_184586_b(hand);
            if (++this.ageCounter < 2) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (!worldIn.field_72995_K) {
                this.initAndReadNBT(stack);
            }
            double dist = 3.0;
            double newPosY = player.field_70163_u;
            double newPosX = player.field_70165_t - dist * Math.cos(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            double newPosZ = player.field_70161_v - dist * Math.sin(MoCTools.realAngle(player.field_70177_z - 90.0f) / 57.29578f);
            if (player.field_70170_p.field_72995_K) break block28;
            try {
                MoCEntityTameableAnimal storedCreature;
                block30: {
                    block29: {
                        int maxCount;
                        MoCPetData newOwner;
                        block31: {
                            this.spawnClass = this.spawnClass.replace("mocreatures:", "").toLowerCase();
                            if (this.spawnClass.equalsIgnoreCase("Wyvern")) {
                                storedCreature = new MoCEntityWyvern(worldIn);
                                ((MoCEntityWyvern)storedCreature).setIsGhost(true);
                                this.isGhost = true;
                            } else if (this.spawnClass.equalsIgnoreCase("WildHorse")) {
                                storedCreature = new MoCEntityHorse(worldIn);
                            } else {
                                storedCreature = (MoCEntityTameableAnimal)EntityList.func_188429_b((ResourceLocation)new ResourceLocation("mocreatures:" + this.spawnClass.toLowerCase()), (World)worldIn);
                                if (storedCreature instanceof MoCEntityBigCat) {
                                    this.isGhost = true;
                                    ((MoCEntityBigCat)storedCreature).setIsGhost(true);
                                }
                            }
                            storedCreature.func_70107_b(newPosX, newPosY, newPosZ);
                            storedCreature.setType(this.creatureType);
                            storedCreature.setTamed(true);
                            storedCreature.setRideable(this.rideable);
                            storedCreature.setAge(this.age);
                            storedCreature.setPetName(this.name);
                            storedCreature.func_70606_j(this.health);
                            storedCreature.setAdult(this.adult);
                            storedCreature.setArmorType(this.armor);
                            storedCreature.setOwnerPetId(this.PetId);
                            storedCreature.setOwnerId(player.func_110124_au());
                            this.ownerName = player.func_70005_c_();
                            if (this.ownerUniqueId != null) break block29;
                            this.ownerUniqueId = player.func_110124_au();
                            if (MoCreatures.instance.mapData == null) break block30;
                            newOwner = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                            maxCount = MoCreatures.proxy.maxTamed;
                            if (MoCTools.isThisPlayerAnOP(player)) {
                                maxCount = MoCreatures.proxy.maxOPTamed;
                            }
                            if (newOwner != null) break block31;
                            if (maxCount > 0 || !MoCreatures.proxy.enableOwnership) {
                                MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                            }
                            break block30;
                        }
                        if (newOwner.getTamedList().func_74745_c() >= maxCount && MoCreatures.proxy.enableOwnership) break block30;
                        MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                        break block30;
                    }
                    if (!this.ownerUniqueId.equals(player.func_110124_au()) && MoCreatures.instance.mapData != null) {
                        MoCPetData oldOwner = MoCreatures.instance.mapData.getPetData(this.ownerUniqueId);
                        MoCPetData newOwner = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
                        int maxCount = MoCreatures.proxy.maxTamed;
                        if (MoCTools.isThisPlayerAnOP(player)) {
                            maxCount = MoCreatures.proxy.maxOPTamed;
                        }
                        if (newOwner == null) {
                            if (maxCount > 0 || !MoCreatures.proxy.enableOwnership) {
                                MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                            }
                        } else if (newOwner.getTamedList().func_74745_c() < maxCount || !MoCreatures.proxy.enableOwnership) {
                            MoCreatures.instance.mapData.updateOwnerPet(storedCreature);
                        }
                        if (oldOwner != null) {
                            for (int j = 0; j < oldOwner.getTamedList().func_74745_c(); ++j) {
                                NBTTagCompound petEntry = oldOwner.getTamedList().func_150305_b(j);
                                if (petEntry.func_74762_e("PetId") != this.PetId) continue;
                                oldOwner.getTamedList().func_74744_a(j);
                            }
                        }
                    }
                }
                if (player.field_70170_p.func_72838_d((Entity)storedCreature)) {
                    MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAppear(storedCreature.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 64.0));
                    MoCTools.playCustomSound((Entity)storedCreature, MoCSoundEvents.ENTITY_GENERIC_MAGIC_ENCHANTED);
                    if (storedCreature instanceof MoCEntityBigCat || storedCreature instanceof MoCEntityWyvern || this.creatureType == 21 || this.creatureType == 22) {
                        player.func_184611_a(hand, new ItemStack((Item)MoCItems.amuletghost, 1, 0));
                    } else if (this.creatureType == 26 || this.creatureType == 27 || this.creatureType == 28) {
                        player.func_184611_a(hand, new ItemStack((Item)MoCItems.amuletbone, 1, 0));
                    } else if (this.creatureType > 47 && this.creatureType < 60) {
                        player.func_184611_a(hand, new ItemStack((Item)MoCItems.amuletfairy, 1, 0));
                    } else if (this.creatureType == 39 || this.creatureType == 40) {
                        player.func_184611_a(hand, new ItemStack((Item)MoCItems.amuletpegasus, 1, 0));
                    }
                    MoCPetData petData = MoCreatures.instance.mapData.getPetData(storedCreature.func_184753_b());
                    if (petData != null) {
                        petData.setInAmulet(storedCreature.getOwnerPetId(), false);
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Unable to find class for entity " + this.spawnClass);
                ex.printStackTrace();
            }
        }
        this.ageCounter = 0;
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.PetId = nbt.func_74762_e("PetId");
        this.creatureType = nbt.func_74762_e("CreatureType");
        this.health = nbt.func_74760_g("Health");
        this.age = nbt.func_74762_e("Edad");
        this.name = nbt.func_74779_i("Name");
        int spawnClassOld = nbt.func_74762_e("SpawnClass");
        if (spawnClassOld > 0) {
            if (spawnClassOld == 100) {
                this.spawnClass = "Wyvern";
                this.isGhost = true;
            } else {
                this.spawnClass = "WildHorse";
            }
            nbt.func_82580_o("SpawnClass");
        } else {
            this.spawnClass = nbt.func_74779_i("SpawnClass");
        }
        this.rideable = nbt.func_74767_n("Rideable");
        this.armor = nbt.func_74771_c("Armor");
        this.adult = nbt.func_74767_n("Adult");
        this.ownerName = nbt.func_74779_i("OwnerName");
        if (nbt.func_186855_b("OwnerUUID")) {
            this.ownerUniqueId = nbt.func_186857_a("OwnerUUID");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("PetId", this.PetId);
        nbt.func_74768_a("CreatureType", this.creatureType);
        nbt.func_74776_a("Health", this.health);
        nbt.func_74768_a("Edad", this.age);
        nbt.func_74778_a("Name", this.name);
        nbt.func_74778_a("SpawnClass", this.spawnClass);
        nbt.func_74757_a("Rideable", this.rideable);
        nbt.func_74774_a("Armor", this.armor);
        nbt.func_74757_a("Adult", this.adult);
        nbt.func_74778_a("OwnerName", this.ownerName);
        if (this.ownerUniqueId != null) {
            nbt.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.initAndReadNBT(stack);
        tooltip.add(TextFormatting.AQUA + this.spawnClass);
        if (!this.name.equals("")) {
            tooltip.add(TextFormatting.BLUE + this.name);
        }
        if (!this.ownerName.equals("")) {
            tooltip.add(TextFormatting.DARK_BLUE + "Owned by " + this.ownerName);
        }
    }

    private void initAndReadNBT(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtcompound = itemstack.func_77978_p();
        this.readFromNBT(nbtcompound);
    }
}

