/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.item;

import com.google.common.collect.Multimap;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.item.MoCItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class MoCItemWeapon
extends MoCItem {
    private final Item.ToolMaterial material;
    private final float attackDamage;
    private int specialWeaponType = 0;

    public MoCItemWeapon(String name, Item.ToolMaterial material) {
        super(name);
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.attackDamage = 3.0f + material.func_78000_c();
    }

    public MoCItemWeapon(String name, Item.ToolMaterial par2ToolMaterial, int damageType) {
        this(name, par2ToolMaterial);
        this.specialWeaponType = damageType;
    }

    public float getAttackDamage() {
        return this.material.func_78000_c();
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        if (state.func_177230_c() instanceof BlockWeb) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (MoCreatures.proxy.weaponEffects) {
            EnumHand hand = attacker.func_184600_cs() == null ? EnumHand.MAIN_HAND : attacker.func_184600_cs();
            int timer = 15;
            int fire_aspect = 5 * EnchantmentHelper.func_90036_a((EntityLivingBase)attacker);
            int poisonous = 5 * EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"mod_lavacow:poisonous"), (ItemStack)attacker.func_184586_b(hand));
            switch (this.specialWeaponType) {
                case 1: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, timer * 20 + poisonous, 1));
                    break;
                }
                case 2: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, timer * 20, 0));
                    break;
                }
                case 3: {
                    target.func_70015_d(timer + fire_aspect);
                    break;
                }
                case 4: {
                    target.func_70690_d(new PotionEffect(target instanceof EntityPlayer ? MobEffects.field_76431_k : MobEffects.field_76437_t, timer * 20, 0));
                    break;
                }
                case 5: {
                    target.func_70690_d(new PotionEffect(target instanceof EntityPlayer ? MobEffects.field_76440_q : MobEffects.field_82731_v, timer * 20, 0));
                    break;
                }
            }
        }
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean onBlockDestroyed(ItemStack par1ItemStack, int par2, int par3, int par4, int par5, EntityLiving par6EntityLiving) {
        par1ItemStack.func_77972_a(2, (EntityLivingBase)par6EntityLiving);
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() instanceof BlockWeb;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase playerIn) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, playerIn);
        }
        return true;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
        }
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (MoCreatures.proxy.weaponEffects) {
            switch (this.specialWeaponType) {
                case 1: {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.sting_weapon_dirt", (Object[])new Object[]{15}));
                    break;
                }
                case 2: {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.sting_weapon_frost", (Object[])new Object[]{15}));
                    break;
                }
                case 3: {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.sting_weapon_fire", (Object[])new Object[]{15}));
                    break;
                }
                case 4: {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.sting_weapon_cave", (Object[])new Object[]{15}));
                    break;
                }
                case 5: {
                    tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"info.mocreatures.sting_weapon_undead", (Object[])new Object[]{15}));
                    break;
                }
            }
        }
    }
}

