/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.autocrafting.IngredientUtil;
import mezz.jei.autocrafting.RecipeBookmarkGroup;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.autocrafting.toposort.TopologicalSort;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.bookmarks.DummyBookmarkItem;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class RecipeChain {
    public final MutableValueGraph<RecipeBookmarkItem<?>, Long> graphStorage = ValueGraphBuilder.directed().allowsSelfLoops(false).nodeOrder(ElementOrder.unordered()).expectedNodeCount(128).build();
    public final Map<RecipeBookmarkItem<?>, List<RecipeBookmarkItem<?>>> secondaryOutputs = new Object2ObjectOpenHashMap();
    private final RecipeBookmarkGroup group;

    public RecipeChain(RecipeBookmarkGroup group) {
        this.group = group;
    }

    public boolean addOutput(RecipeBookmarkItem<?> recipeOutput) {
        for (RecipeBookmarkItem input : this.graphStorage.nodes()) {
            if (!IngredientUtil.aliasesContains(input.aliases, recipeOutput.ingredient)) continue;
            input.setIngredient(recipeOutput.ingredient);
            input.populateWith(recipeOutput.recipe, recipeOutput.category);
            this.expandNodeFirst(input);
            this.removeDanglingNodes();
            return true;
        }
        recipeOutput.selfOutputAmount = recipeOutput.outputAmount;
        this.expandNodeFirst(recipeOutput);
        return false;
    }

    private void expandNodeFirst(RecipeBookmarkItem<?> requester) {
        this.expandNodeFirst(requester, true);
    }

    private void expandNodeFirst(RecipeBookmarkItem<?> requester, boolean recurse) {
        if (!requester.isPopulated()) {
            requester.populateWithFavorite();
            if (!requester.isPopulated()) {
                return;
            }
        }
        for (RecipeBookmarkItem<?> input : requester.inputs) {
            RecipeBookmarkItem<Object> needed = this.findOutputUsingAnAlias(input);
            if (needed == null) {
                RecipeBookmarkItem<?> possiblePrimaryOutput;
                needed = new RecipeBookmarkItem(input.aliases);
                this.group.addItemInternal(needed);
                if (recurse) {
                    needed.populateWithFavorite();
                    this.expandNodeFirst(needed);
                }
                if ((possiblePrimaryOutput = this.findOutputWithSameRecipe(needed)) != null) {
                    needed.secondaryTo = possiblePrimaryOutput;
                    this.secondaryOutputs.computeIfAbsent(possiblePrimaryOutput, k -> new ObjectArrayList()).add(needed);
                }
            }
            try {
                this.graphStorage.putEdgeValue(requester, needed, (Object)input.amount);
                needed.setGroup(this.group);
            }
            catch (IllegalArgumentException e) {
                Log.get().error("Failed to add edge from {} to {}.", requester, needed, (Object)e);
            }
        }
    }

    private Map<String, RecipeBookmarkItem<?>> getAliasMap() {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        Object2ObjectOpenHashMap aliasToNode = new Object2ObjectOpenHashMap();
        this.group.getItemsInternal().forEach(arg_0 -> RecipeChain.lambda$getAliasMap$2((Map)aliasToNode, ingredientRegistry, arg_0));
        return aliasToNode;
    }

    public RecipeBookmarkItem<?> findOutputUsingAnAlias(RecipeBookmarkItem<?> output) {
        Map<String, RecipeBookmarkItem<?>> aliasToNode = this.getAliasMap();
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        List aliasIds = output.aliases.stream().map(ingredientRegistry::getUniqueId).collect(Collectors.toList());
        for (String uniqueId : aliasIds) {
            RecipeBookmarkItem<?> node = aliasToNode.get(uniqueId);
            if (node == null) continue;
            if (!node.foundAliases) {
                node.foundAliases = true;
                node.aliases = new ObjectArrayList(output.aliases);
                node.setIngredient(output.ingredient);
            }
            node.aliases.removeIf(a -> !aliasIds.contains(ingredientRegistry.getUniqueId(a)));
            return node;
        }
        return null;
    }

    public RecipeBookmarkItem<?> findOutputWithSameRecipe(RecipeBookmarkItem<?> output) {
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        String uniqueId = ingredientRegistry.getUniqueId(output.ingredient);
        return this.group.getItemsInternal().stream().filter(node -> ((RecipeBookmarkItem)node).recipe != null && !uniqueId.equals(ingredientRegistry.getUniqueId(output.ingredient)) && ((RecipeBookmarkItem)node).recipe.equals(output.recipe)).findFirst().orElse(null);
    }

    public void calculateCrafting() {
        for (RecipeBookmarkItem node : this.graphStorage.nodes()) {
            node.amount = node.selfOutputAmount;
        }
        TopologicalSort.topologicalSort(this.graphStorage, (r, r1) -> {
            if (r.equals(r1.secondaryTo)) {
                return 1;
            }
            if (r1.equals(r.secondaryTo)) {
                return -1;
            }
            return 0;
        }).forEach(this::calculateCrafting);
    }

    public void calculateCrafting(RecipeBookmarkItem<?> needed) {
        if (this.graphStorage.predecessors(needed).isEmpty()) {
            return;
        }
        for (RecipeBookmarkItem requester : this.graphStorage.predecessors(needed)) {
            if (requester.outputAmount == 0L) {
                Log.get().warn("Requester {} is apparently not made by its own recipe? Curious.", (Object)requester);
                continue;
            }
            needed.amount += (requester.amount + requester.outputAmount - 1L) / requester.outputAmount * this.edgeValue(requester, needed);
        }
        if (needed.secondaryTo != null) {
            needed.secondaryTo.amount = Math.max(needed.secondaryTo.amount, needed.amount);
        }
    }

    private Long edgeValue(RecipeBookmarkItem<?> nodeU, RecipeBookmarkItem<?> nodeV) {
        Long value = (Long)this.graphStorage.edgeValueOrDefault(nodeU, nodeV, null);
        if (value == null) {
            Preconditions.checkArgument((boolean)this.graphStorage.nodes().contains(nodeU), (String)"Node %s is not an element of this graph.", nodeU);
            Preconditions.checkArgument((boolean)this.graphStorage.nodes().contains(nodeV), (String)"Node %s is not an element of this graph.", nodeV);
            throw new IllegalArgumentException(String.format("Edge connecting %s to %s is not present in this graph.", nodeU, nodeV));
        }
        return value;
    }

    public List<RecipeBookmarkItem<?>> getDisplayOutputs() {
        return TopologicalSort.topologicalSort(this.graphStorage, (r, r1) -> {
            if (r.equals(r1.secondaryTo)) {
                return 1;
            }
            if (r1.equals(r.secondaryTo)) {
                return -1;
            }
            return 0;
        });
    }

    public void removeNode(RecipeBookmarkItem<?> node) {
        if (!this.graphStorage.nodes().contains(node)) {
            Log.get().warn("Tried to remove node that's not in the graph: {}", node);
            return;
        }
        this.graphStorage.removeNode(node);
        List<RecipeBookmarkItem<?>> affectedSecondaries = this.secondaryOutputs.remove(node);
        if (affectedSecondaries != null && !affectedSecondaries.isEmpty()) {
            if (affectedSecondaries.size() == 1) {
                affectedSecondaries.get((int)0).secondaryTo = null;
            } else {
                for (int i = 1; i < affectedSecondaries.size(); ++i) {
                    affectedSecondaries.get((int)i).secondaryTo = affectedSecondaries.get(0);
                }
                affectedSecondaries.remove(0);
                this.secondaryOutputs.put(affectedSecondaries.get(0), affectedSecondaries);
            }
        }
        this.removeDanglingNodes();
        for (RecipeBookmarkItem predecessor : new ObjectOpenHashSet((Collection)this.graphStorage.nodes())) {
            this.expandNodeFirst(predecessor, false);
        }
        this.calculateCrafting();
    }

    public void removeDanglingNodes() {
        this.calculateCrafting();
        ArrayList<RecipeBookmarkItem> nodesToRemove = new ArrayList<RecipeBookmarkItem>();
        for (RecipeBookmarkItem otherNode : this.graphStorage.nodes()) {
            if (otherNode.amount != 0L) continue;
            nodesToRemove.add(otherNode);
        }
        for (RecipeBookmarkItem otherNode : nodesToRemove) {
            this.graphStorage.removeNode((Object)otherNode);
        }
    }

    public void calculateMissingIngredients(Stack<RecipeBookmarkItem<?>> recipeList, List<BookmarkItem<?>> missing) {
        for (RecipeBookmarkItem node : this.graphStorage.nodes()) {
            node.amount = node.selfOutputAmount;
        }
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        InventoryPlayer inv = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        Object2LongOpenHashMap invCounts = new Object2LongOpenHashMap(inv.func_70302_i_() * 2);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            String uniqueId = ingredientRegistry.getUniqueId(stack);
            invCounts.compute(uniqueId, (k, v) -> v == null ? (long)stack.func_190916_E() : v + (long)stack.func_190916_E());
        }
        HashMap lookup = missing == null ? null : new HashMap();
        TopologicalSort.topologicalSort(this.graphStorage, (r, r1) -> {
            if (r.equals(r1.secondaryTo)) {
                return 1;
            }
            if (r1.equals(r.secondaryTo)) {
                return -1;
            }
            return 0;
        }).forEach(arg_0 -> this.lambda$calculateMissingIngredients$9((Map)invCounts, recipeList, lookup, arg_0));
        if (missing != null) {
            for (Map.Entry entry : lookup.entrySet()) {
                missing.add((BookmarkItem<?>)entry.getValue());
            }
        }
        this.calculateCrafting();
    }

    public void calculateMissingIngredients(RecipeBookmarkItem<?> needed, Map<String, Long> invCounts, Stack<RecipeBookmarkItem<?>> recipeList, Map<String, BookmarkItem<?>> lookup) {
        this.calculateCrafting(needed);
        if (needed.amount <= 0L) {
            return;
        }
        String uniqueId = null;
        if (needed.selfOutputAmount == 0L) {
            uniqueId = Internal.getIngredientRegistry().getUniqueId(needed.ingredient);
            invCounts.computeIfPresent(uniqueId, (k, v) -> {
                needed.amount = Math.max(0L, needed.amount - v);
                return Math.max(0L, v - needed.amount);
            });
        }
        if (recipeList != null && needed.amount > 0L && needed.category != null) {
            recipeList.add((RecipeBookmarkItem<?>)needed.copy());
        } else if (lookup != null && needed.amount > 0L && this.graphStorage.successors(needed).isEmpty()) {
            if (uniqueId == null) {
                uniqueId = Internal.getIngredientRegistry().getUniqueId(needed.ingredient);
            }
            lookup.compute(uniqueId, (k, v) -> {
                if (v == null) {
                    long staticAmount = (int)needed.amount;
                    return new DummyBookmarkItem<RecipeBookmarkItem>(needed, null, () -> staticAmount);
                }
                v.amount += needed.amount;
                return v;
            });
        }
    }

    public void rebuildGraph() {
        for (BookmarkItem<?> node : this.group.getItemsInternal()) {
            if (!(node instanceof RecipeBookmarkItem)) continue;
            RecipeBookmarkItem requester = (RecipeBookmarkItem)node;
            requester.populateSelf(this);
            for (RecipeBookmarkItem<?> input : requester.inputs) {
                RecipeBookmarkItem other = this.findOutputUsingAnAlias(input);
                if (other == null && input.inputs != null) {
                    Log.get().warn("Failed to get connections for {}", input);
                }
                try {
                    this.graphStorage.putEdgeValue((Object)requester, other != null ? other : new RecipeBookmarkItem(input.aliases), (Object)input.amount);
                }
                catch (IllegalArgumentException e) {
                    Log.get().error("Failed to add edge from {} to {}.", (Object)requester, input, (Object)e);
                }
            }
        }
    }

    private /* synthetic */ void lambda$calculateMissingIngredients$9(Map invCounts, Stack recipeList, Map lookup, RecipeBookmarkItem ingredient) {
        this.calculateMissingIngredients(ingredient, invCounts, recipeList, lookup);
    }

    private static /* synthetic */ void lambda$getAliasMap$2(Map aliasToNode, IngredientRegistry ingredientRegistry, BookmarkItem node) {
        ((RecipeBookmarkItem)node).aliases.forEach(alias -> aliasToNode.put(ingredientRegistry.getUniqueId(alias), (RecipeBookmarkItem)node));
    }
}

