/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.config.Config;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.PageNavigation;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.bookmarks.BookmarkGrid;
import mezz.jei.gui.overlay.bookmarks.group.BookmarkGroupOrganizer;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.render.BookmarkListBatchRenderer;
import mezz.jei.util.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

public class BookmarkGridWithNavigation
implements IShowsRecipeFocuses,
IMouseHandler,
IGhostIngredientDragSource {
    private static final int NAVIGATION_HEIGHT = 20;
    public static final int BOOKMARK_TAB_WIDTH = 10;
    private int firstItemIndex = 0;
    private final IPaged pageDelegate;
    private List<Integer> pageBoundaries;
    private final PageNavigation navigation;
    private BookmarkGroupOrganizer groupOrganizer;
    private final GuiScreenHelper guiScreenHelper;
    private final BookmarkGrid bookmarkGrid;
    private final IIngredientGridSource ingredientSource;
    private Rectangle area = new Rectangle();

    public BookmarkGridWithNavigation(IIngredientGridSource ingredientSource, GuiScreenHelper guiScreenHelper, GridAlignment alignment) {
        this.groupOrganizer = new BookmarkGroupOrganizer();
        this.bookmarkGrid = new BookmarkGrid(alignment, this.groupOrganizer);
        this.ingredientSource = ingredientSource;
        this.guiScreenHelper = guiScreenHelper;
        this.pageDelegate = new BookmarkGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false);
    }

    public void updateLayout(boolean resetToFirstPage) {
        List<IIngredientListElement> ingredientList;
        if (resetToFirstPage) {
            this.firstItemIndex = 0;
        }
        if (this.firstItemIndex >= (ingredientList = this.ingredientSource.getIngredientList()).size()) {
            this.firstItemIndex = 0;
        }
        this.bookmarkGrid.getGuiIngredientSlots().set(this.firstItemIndex, ingredientList);
        this.pageBoundaries = ((BookmarkListBatchRenderer)this.bookmarkGrid.getGuiIngredientSlots()).sizePages(ingredientList);
        this.navigation.updatePageState();
    }

    public boolean updateBounds(Rectangle availableArea, Set<Rectangle> guiExclusionAreas, int minWidth) {
        Rectangle estimatedNavigationArea = new Rectangle(availableArea.x, availableArea.y, availableArea.width, 20);
        Rectangle movedNavigationArea = MathUtil.moveDownToAvoidIntersection(guiExclusionAreas, estimatedNavigationArea);
        int navigationMaxY = movedNavigationArea.y + movedNavigationArea.height;
        Rectangle boundsWithoutNavigation = new Rectangle(availableArea.x + (Config.areRecipeBookmarksEnabled() ? 10 : 0), navigationMaxY, availableArea.width - (Config.areRecipeBookmarksEnabled() ? 10 : 0), availableArea.height - navigationMaxY);
        Rectangle groupOrganizerBounds = new Rectangle(availableArea.x, navigationMaxY, availableArea.width, availableArea.height - navigationMaxY);
        boolean gridHasRoom = this.bookmarkGrid.updateBounds(boundsWithoutNavigation, minWidth, guiExclusionAreas);
        if (!gridHasRoom) {
            return false;
        }
        Rectangle displayArea = this.bookmarkGrid.getArea();
        Rectangle navigationArea = new Rectangle(2, movedNavigationArea.y, displayArea.width, 20);
        this.navigation.updateBounds(navigationArea);
        this.groupOrganizer.updateBounds(groupOrganizerBounds);
        this.area = displayArea.union(navigationArea);
        return true;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.bookmarkGrid.draw(minecraft, mouseX, mouseY);
        this.navigation.draw(minecraft, mouseX, mouseY, partialTicks);
        this.groupOrganizer.draw(minecraft, mouseX, mouseY);
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (!this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY)) {
            this.bookmarkGrid.drawTooltips(minecraft, mouseX, mouseY);
            this.groupOrganizer.drawTooltips(minecraft, mouseX, mouseY);
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        return !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY) && (this.bookmarkGrid.handleMouseClicked(mouseX, mouseY) || this.navigation.handleMouseClickedButtons(mouseX, mouseY));
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        IIngredientListElement element = this.getElementUnderMouse();
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && element != null) {
            BookmarkItem item = (BookmarkItem)element.getIngredient();
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (item.ingredient instanceof ItemStack) {
                    int stackSize = ((ItemStack)item.ingredient).func_77976_d();
                    item.changeAmount(scrollDelta < 0 ? (long)(-stackSize) : (long)stackSize);
                } else if (item.ingredient instanceof FluidStack) {
                    item.changeAmount(scrollDelta < 0 ? -1000L : 1000L);
                } else {
                    item.changeAmount(scrollDelta < 0 ? -1L : 1L);
                }
            } else {
                item.changeAmount(scrollDelta < 0 ? -1L : 1L);
            }
            Internal.getBookmarkList().saveBookmarks();
            this.bookmarkGrid.getGuiIngredientSlots().invalidateBuffer();
            return true;
        }
        if (scrollDelta < 0) {
            this.pageDelegate.nextPage();
            return true;
        }
        if (scrollDelta > 0) {
            this.pageDelegate.previousPage();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        return this.bookmarkGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    @Override
    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        return this.bookmarkGrid.getElementUnderMouse();
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.bookmarkGrid.canSetFocusWithMouse();
    }

    public BookmarkGroupOrganizer getBookmarkGroupOrganizer() {
        return this.groupOrganizer;
    }

    private class BookmarkGridPaged
    implements IPaged {
        private BookmarkGridPaged() {
        }

        @Override
        public boolean nextPage() {
            int pageNum = this.getPageNumber();
            if (pageNum == this.getPageCount() - 1) {
                BookmarkGridWithNavigation.this.updateLayout(false);
                return false;
            }
            BookmarkGridWithNavigation.this.firstItemIndex = (Integer)BookmarkGridWithNavigation.this.pageBoundaries.get(pageNum + 1);
            BookmarkGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean previousPage() {
            int pageNum = this.getPageNumber();
            if (pageNum == 0) {
                BookmarkGridWithNavigation.this.updateLayout(true);
                return false;
            }
            BookmarkGridWithNavigation.this.firstItemIndex = (Integer)BookmarkGridWithNavigation.this.pageBoundaries.get(pageNum - 1);
            BookmarkGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.getPageNumber() < this.getPageCount() - 1;
        }

        @Override
        public boolean hasPrevious() {
            return this.getPageNumber() > 0;
        }

        @Override
        public int getPageCount() {
            return BookmarkGridWithNavigation.this.pageBoundaries.size();
        }

        @Override
        public int getPageNumber() {
            if (BookmarkGridWithNavigation.this.pageBoundaries.isEmpty()) {
                BookmarkGridWithNavigation.this.firstItemIndex = 0;
                return 0;
            }
            int index = Collections.binarySearch(BookmarkGridWithNavigation.this.pageBoundaries, BookmarkGridWithNavigation.this.firstItemIndex);
            if (index < 0 && (index = -index - 1) == BookmarkGridWithNavigation.this.pageBoundaries.size()) {
                --index;
            }
            BookmarkGridWithNavigation.this.firstItemIndex = (Integer)BookmarkGridWithNavigation.this.pageBoundaries.get(index);
            return index;
        }
    }
}

