/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.autocrafting.RecipeBookmarkGroup;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.GuiIconButtonSmall;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;

public class RecipeBookmarkButton
extends GuiIconButtonSmall {
    private final IRecipeCategory<?> category;
    private final IRecipeWrapper recipe;
    private RecipeLayout recipeLayout;

    public RecipeBookmarkButton(int id, int width, int height, IDrawable icon, IRecipeCategory<?> category, IRecipeWrapper recipe, RecipeLayout recipeLayout) {
        super(id, 0, 0, width, height, icon);
        this.category = category;
        this.recipe = recipe;
        this.recipeLayout = recipeLayout;
    }

    public void init(RecipeLayout recipeLayout) {
        this.recipeLayout = recipeLayout;
        this.field_146124_l = this.field_146125_m = recipeLayout.getRecipeFavoriteButton().field_146124_l;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.field_146125_m = this.field_146124_l && Config.areRecipeBookmarksEnabled();
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    public void drawToolTip(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146123_n && this.field_146125_m) {
            String tooltipTransfer = Translator.translateToLocal("hei.tooltip.recipe_bookmark");
            TooltipRenderer.drawHoveringText(mc, tooltipTransfer, mouseX, mouseY);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (!super.func_146116_c(mc, mouseX, mouseY)) {
            return false;
        }
        if (!Config.isBookmarkOverlayEnabled()) {
            Config.toggleBookmarkEnabled();
        }
        BookmarkList bookmarkList = Internal.getBookmarkList();
        RecipeBookmarkGroup group = new RecipeBookmarkGroup(bookmarkList.nextId());
        RecipeBookmarkItem<Object> recipeBookmarkItem = new RecipeBookmarkItem<Object>(this.recipeLayout.getRecipeFavoriteButton().getDisplayedIngredient());
        recipeBookmarkItem.setGroup(group);
        recipeBookmarkItem.populateWith(this.recipe, this.category);
        group.addItem(recipeBookmarkItem);
        group.update();
        return bookmarkList.add(group);
    }
}

