/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.autocrafting.favorites.FavoriteRecipes;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class RecipeFavoriteButton
extends GuiIconButton {
    private final IRecipeWrapper recipe;
    private final IRecipeCategory<?> category;
    private List<IGuiIngredient<?>> supportedIngredients;
    private final Set<Integer> favoriteSlots = new IntOpenHashSet();
    private int selectedSlot = 0;
    private RecipeLayout layout;
    private static final Color selectedColor = new Color(0.0f, 0.0f, 1.0f, 0.3f);
    private static final Color favoritedColor = new Color(0.0f, 1.0f, 0.0f, 0.3f);

    public RecipeFavoriteButton(int index, int width, int height, IDrawable offIcon, IDrawable onIcon, IRecipeWrapper recipe, IRecipeCategory<?> category, RecipeLayout layout) {
        super(index, null, null);
        this.tooltipCallback = this::getTooltips;
        this.iconSupplier = () -> this.isIconToggledOn() ? onIcon : offIcon;
        this.mouseClickCallback = this::onMouseClicked;
        this.recipe = recipe;
        this.category = category;
        this.field_146120_f = width;
        this.field_146121_g = height;
        this.layout = layout;
        this.setSupportedIngredients(layout);
    }

    private void setSupportedIngredients(RecipeLayout layout) {
        Function<Map, Stream> filter = map -> map.values().stream().filter(ing -> ing != null && ((IGuiIngredient)ing).getDisplayedIngredient() != null && !((IGuiIngredient)ing).isInput());
        this.supportedIngredients = Internal.getIngredientRegistry().getCraftableIngredientTypes().stream().map(t -> layout.getIngredientsGroup(t).getGuiIngredients()).flatMap(filter).collect(Collectors.toList());
        this.supportedIngredients.forEach(ing -> {
            if (FavoriteRecipes.isFavoriteFor(this.recipe, ing.getDisplayedIngredient())) {
                this.favoriteSlots.add(this.supportedIngredients.indexOf(ing));
            }
        });
        this.field_146125_m = !this.supportedIngredients.isEmpty();
        this.field_146124_l = this.field_146125_m;
    }

    public void init(RecipeLayout layout) {
        this.layout = layout;
        this.setSupportedIngredients(layout);
    }

    protected void getTooltips(List<String> tooltip) {
        if (this.isIconToggledOn()) {
            tooltip.add(Translator.translateToLocal("hei.tooltip.unfavorite"));
        } else {
            tooltip.add(Translator.translateToLocal("hei.tooltip.favorite"));
        }
        tooltip.add(Translator.translateToLocal("hei.tooltip.favorite_scroll"));
    }

    protected boolean isIconToggledOn() {
        return FavoriteRecipes.isFavorite(this.recipe);
    }

    protected boolean onMouseClicked(Minecraft mc, int mouseX, int mouseY) {
        if (GuiScreen.func_146272_n() && this.isIconToggledOn()) {
            FavoriteRecipes.removeFavorite(this.recipe);
            this.favoriteSlots.clear();
            return true;
        }
        FavoriteRecipes.toggleFavorite(this.supportedIngredients.get(this.selectedSlot).getDisplayedIngredient(), this.recipe, this.category);
        if (this.favoriteSlots.contains(this.selectedSlot)) {
            this.favoriteSlots.remove(this.selectedSlot);
        } else {
            this.favoriteSlots.add(this.selectedSlot);
        }
        return true;
    }

    @Override
    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        if (!(this.func_146115_a() || this.field_146125_m && this.layout.getRecipeBookmarkButton().func_146115_a())) {
            return;
        }
        this.supportedIngredients.get(this.selectedSlot).drawHighlight(mc, selectedColor, this.layout.getPosX(), this.layout.getPosY());
        if (this.isIconToggledOn()) {
            for (int slot : this.favoriteSlots) {
                this.supportedIngredients.get(slot).drawHighlight(mc, favoritedColor, this.layout.getPosX(), this.layout.getPosY());
            }
        }
    }

    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        if (!(this.field_146124_l && this.field_146125_m && this.func_146115_a())) {
            return false;
        }
        if (scrollDelta < 0) {
            this.selectedSlot = (this.selectedSlot + this.supportedIngredients.size() - 1) % this.supportedIngredients.size();
        } else if (scrollDelta > 0) {
            this.selectedSlot = (this.selectedSlot + 1) % this.supportedIngredients.size();
        }
        return true;
    }

    @Nullable
    public Object getDisplayedIngredient() {
        return this.supportedIngredients.get(this.selectedSlot).getDisplayedIngredient();
    }
}

