/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import mezz.jei.collect.Char2ObjectSingletonMap;
import mezz.jei.util.Substring;
import org.apache.commons.lang3.ArrayUtils;

public class Node<T>
extends Substring {
    private T[] data = ObjectArrays.EMPTY_ARRAY;
    private Char2ObjectMap<Node<T>> edges = Char2ObjectMaps.emptyMap();
    @Nullable
    private Node<T> suffix = null;

    Node(Substring string) {
        super(string);
    }

    void getData(Collection<T> collection) {
        for (int i = 0; i < this.data.length; ++i) {
            collection.add(this.data[i]);
        }
        for (Node e : this.edges.values()) {
            e.getData(collection);
        }
    }

    boolean addRef(T index) {
        if (this.contains(index)) {
            return false;
        }
        this.addValue(index);
        Node<T> iter = this.suffix;
        while (iter != null && !iter.contains(index)) {
            iter.addValue(index);
            iter = iter.suffix;
        }
        return true;
    }

    protected boolean contains(T index) {
        for (T t : this.data) {
            if (t != index) continue;
            return true;
        }
        return false;
    }

    protected void addEdge(Node<T> e) {
        if (this.edges.isEmpty()) {
            this.edges = new Char2ObjectSingletonMap<Node<T>>(e.charAt(0), e);
        } else if (this.edges.size() == 1) {
            Char2ObjectArrayMap newEdges = new Char2ObjectArrayMap(2);
            newEdges.putAll(this.edges);
            newEdges.put(e.charAt(0), e);
            this.edges = newEdges;
        } else if (this.edges.size() == 7) {
            Char2ObjectOpenHashMap newEdges = new Char2ObjectOpenHashMap(this.edges);
            newEdges.put(e.charAt(0), e);
            this.edges = newEdges;
        } else {
            this.edges.put(e.charAt(0), e);
        }
    }

    @Nullable
    Node<T> getEdge(char ch) {
        return (Node)this.edges.get(ch);
    }

    @Nullable
    Node<T> getEdge(Substring substring) {
        if (substring.isEmpty()) {
            return null;
        }
        return (Node)this.edges.get(substring.charAt(0));
    }

    @Nullable
    Node<T> getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node<T> suffix) {
        this.suffix = suffix;
    }

    protected void addValue(T index) {
        this.data = ArrayUtils.add((Object[])this.data, index);
    }

    @Override
    public String toString() {
        return "Node: size:" + this.data.length + " Edges: " + this.edges;
    }

    public IntSummaryStatistics nodeSizeStats() {
        return this.nodeSizes().summaryStatistics();
    }

    private IntStream nodeSizes() {
        return IntStream.concat(IntStream.of(this.data.length), this.edges.values().stream().flatMapToInt(Node::nodeSizes));
    }

    public String nodeEdgeStats() {
        IntSummaryStatistics edgeCounts = this.nodeEdgeCounts().summaryStatistics();
        IntSummaryStatistics edgeLengths = this.nodeEdgeLengths().summaryStatistics();
        return "Edge counts: " + edgeCounts + "\nEdge lengths: " + edgeLengths;
    }

    private IntStream nodeEdgeCounts() {
        return IntStream.concat(IntStream.of(this.edges.size()), this.edges.values().stream().flatMapToInt(Node::nodeEdgeCounts));
    }

    private IntStream nodeEdgeLengths() {
        return IntStream.concat(this.edges.values().stream().mapToInt(Substring::length), this.edges.values().stream().flatMapToInt(Node::nodeEdgeLengths));
    }

    public void printTree(PrintWriter out, boolean includeSuffixLinks) {
        out.println("digraph {");
        out.println("\trankdir = LR;");
        out.println("\tordering = out;");
        out.println("\tedge [arrowsize=0.4,fontsize=10]");
        out.println("\t" + Node.nodeId(this) + " [label=\"\",style=filled,fillcolor=lightgrey,shape=circle,width=.1,height=.1];");
        out.println("//------leaves------");
        this.printLeaves(out);
        out.println("//------internal nodes------");
        this.printInternalNodes(this, out);
        out.println("//------edges------");
        this.printEdges(out);
        if (includeSuffixLinks) {
            out.println("//------suffix links------");
            this.printSLinks(out);
        }
        out.println("}");
    }

    private void printLeaves(PrintWriter out) {
        if (this.edges.isEmpty()) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + Arrays.toString(this.data) + "\",shape=point,style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        } else {
            for (Node edge : this.edges.values()) {
                edge.printLeaves(out);
            }
        }
    }

    private void printInternalNodes(Node<T> root, PrintWriter out) {
        if (this != root && !this.edges.isEmpty()) {
            out.println("\t" + Node.nodeId(this) + " [label=\"" + Arrays.toString(this.data) + "\",style=filled,fillcolor=lightgrey,shape=circle,width=.07,height=.07]");
        }
        for (Node edge : this.edges.values()) {
            edge.printInternalNodes(root, out);
        }
    }

    private void printEdges(PrintWriter out) {
        for (Node child : this.edges.values()) {
            out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(child) + " [label=\"" + child + "\",weight=10]");
            child.printEdges(out);
        }
    }

    private void printSLinks(PrintWriter out) {
        if (this.suffix != null) {
            out.println("\t" + Node.nodeId(this) + " -> " + Node.nodeId(this.suffix) + " [label=\"\",weight=0,style=dotted]");
        }
        for (Node edge : this.edges.values()) {
            edge.printSLinks(out);
        }
    }

    private static <T> String nodeId(Node<T> node) {
        return "node" + Integer.toHexString(node.hashCode()).toUpperCase();
    }

    public static class Root<T>
    extends Node<T> {
        public Root() {
            super(new Substring(""));
        }

        @Override
        protected boolean contains(T value) {
            return true;
        }

        @Override
        protected void addValue(T index) {
        }
    }
}

