/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting;

import java.util.Stack;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IAutocraftingHandler;
import mezz.jei.api.recipe.transfer.IRecipeCraftingHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.autocrafting.RecipeChain;
import mezz.jei.recipes.RecipeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;

public class AutocraftingHandler
implements IAutocraftingHandler {
    @Nullable
    private RecipeChain currentChain;
    @Nullable
    private RecipeBookmarkItem<?> currentRequester;
    private Stack<RecipeBookmarkItem<?>> recipesToAutocraft;

    public void start(RecipeChain chain) {
        this.currentChain = chain;
        this.recipesToAutocraft = new Stack();
        chain.calculateMissingIngredients(this.recipesToAutocraft, null);
        if (this.recipesToAutocraft.isEmpty()) {
            this.stop();
            return;
        }
        chain.calculateCrafting();
        this.autocraftLoop();
    }

    private boolean autocraft() {
        if (this.currentRequester == null) {
            this.stop();
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == null) {
            this.stop();
            return false;
        }
        Container openContainer = player.field_71070_bA;
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        if (openContainer == null) {
            this.stop();
            return false;
        }
        IRecipeCategory<?> recipeCategory = this.currentRequester.category;
        IRecipeLayout recipeLayout = this.currentRequester.createLayout();
        IRecipeTransferHandler recipeTransferHandler = recipeRegistry.getRecipeTransferHandler(openContainer, recipeCategory);
        if (recipeTransferHandler == null || !(recipeTransferHandler instanceof IRecipeCraftingHandler)) {
            return true;
        }
        IRecipeCraftingHandler craftingHandler = (IRecipeCraftingHandler)recipeTransferHandler;
        if (craftingHandler.craft(openContainer, recipeLayout, (EntityPlayer)player, (int)this.currentRequester.getMultiplier(), false) == null) {
            craftingHandler.craft(openContainer, recipeLayout, (EntityPlayer)player, (int)this.currentRequester.getMultiplier(), true);
            return false;
        }
        return true;
    }

    private void autocraftLoop() {
        if (this.recipesToAutocraft.isEmpty()) {
            this.stop();
            return;
        }
        do {
            this.currentRequester = this.recipesToAutocraft.pop();
        } while (this.autocraft() && !this.recipesToAutocraft.isEmpty());
        if (this.recipesToAutocraft != null && this.recipesToAutocraft.isEmpty()) {
            this.stop();
        }
    }

    @Override
    public void stepFinished(boolean success, int amount) {
        if (this.recipesToAutocraft == null) {
            return;
        }
        if ((long)amount < this.currentRequester.amount) {
            this.currentRequester.amount -= (long)amount;
            this.recipesToAutocraft.push(this.currentRequester);
        }
        this.autocraftLoop();
    }

    @Override
    public void stop() {
        this.currentChain = null;
        this.currentRequester = null;
        this.recipesToAutocraft = null;
    }

    @Override
    public boolean isActive() {
        return this.currentChain != null;
    }
}

