/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.util.LegacyUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IngredientUtil {
    public static int getCount(Object ingredient) {
        if (ingredient instanceof ItemStack) {
            return ((ItemStack)ingredient).func_190916_E();
        }
        if (ingredient instanceof FluidStack) {
            return ((FluidStack)ingredient).amount;
        }
        return 0;
    }

    public static <A, B> boolean equals(A o1, B o2) {
        IIngredientType<A> type1 = Internal.getIngredientRegistry().getIngredientType(o1);
        IIngredientType<B> type2 = Internal.getIngredientRegistry().getIngredientType(o2);
        if (type1 == null || type2 == null || type1 != type2) {
            return false;
        }
        return Internal.getIngredientRegistry().getUniqueId(o1).equals(Internal.getIngredientRegistry().getUniqueId(o2));
    }

    public static <A, B> boolean aliasesContains(List<A> l1, B o2) {
        for (A a : l1) {
            if (!IngredientUtil.equals(a, o2)) continue;
            return true;
        }
        return false;
    }

    public static <A, B> boolean aliasesEquals(List<A> l1, List<B> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (IngredientUtil.equals(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> BookmarkItem<T> normalizeBookmark(BookmarkItem<T> ingredient) {
        IIngredientHelper<BookmarkItem<T>> ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredient);
        BookmarkItem<T> copy = LegacyUtil.getIngredientCopy(ingredient, ingredientHelper);
        copy.ingredient = IngredientUtil.normalizeCopy(copy.ingredient);
        return copy;
    }

    public static <T> void normalize(T ingredient) {
        if (ingredient instanceof ItemStack) {
            ((ItemStack)ingredient).func_190920_e(1);
        } else if (ingredient instanceof FluidStack) {
            ((FluidStack)ingredient).amount = 1000;
        }
    }

    public static <T> T normalizeCopy(T orig) {
        T ingredient = LegacyUtil.getIngredientCopy(orig, Internal.getIngredientRegistry().getIngredientHelper(orig));
        if (ingredient instanceof ItemStack) {
            ((ItemStack)ingredient).func_190920_e(1);
        } else if (ingredient instanceof FluidStack) {
            ((FluidStack)ingredient).amount = 1000;
        }
        return ingredient;
    }
}

