/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.autocrafting.IngredientUtil;
import mezz.jei.autocrafting.RecipeBookmarkGroup;
import mezz.jei.autocrafting.RecipeChain;
import mezz.jei.autocrafting.favorites.FavoriteRecipes;
import mezz.jei.bookmarks.BookmarkGroup;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.bookmarks.DummyBookmarkItem;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.ingredients.Ingredients;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeBookmarkItem<I>
extends BookmarkItem<I> {
    public long outputAmount = 0L;
    public long selfOutputAmount = 0L;
    public IRecipeWrapper recipe;
    public IRecipeCategory<?> category;
    public List<RecipeBookmarkItem<?>> inputs;
    public BookmarkItem<?> secondaryTo;
    public List<I> aliases;
    public boolean foundAliases = false;
    private List<DummyBookmarkItem<?>> inputDummyItems;

    public RecipeBookmarkItem(I ingredient) {
        super(ingredient);
        this.aliases = new ObjectArrayList();
        this.aliases.add(this.ingredient);
    }

    public RecipeBookmarkItem(List<I> aliases) {
        super(aliases.get(0));
        this.aliases = aliases;
        this.aliases.set(0, this.ingredient);
    }

    public RecipeBookmarkItem(List<I> aliases, int amount) {
        super(aliases.get(0));
        this.aliases = aliases;
        this.aliases.set(0, this.ingredient);
        this.amount = amount;
    }

    public RecipeBookmarkItem(RecipeBookmarkItem<I> other) {
        super(other.ingredient);
        this.aliases = other.aliases;
        this.foundAliases = other.foundAliases;
        this.amount = other.amount;
        this.outputAmount = other.outputAmount;
        this.selfOutputAmount = other.selfOutputAmount;
        this.recipe = other.recipe;
        this.category = other.category;
        this.inputs = other.inputs;
        this.secondaryTo = other.secondaryTo;
    }

    public void populateWithFavorite() {
        if (this.recipe != null) {
            return;
        }
        for (I alias : this.aliases) {
            IRecipeWrapper favorite = FavoriteRecipes.getFavorite(alias);
            if (favorite == null) continue;
            IRecipeCategory<?> favoriteCategory = FavoriteRecipes.getFavoriteCategory(alias);
            this.ingredient = alias;
            this.populateWith(favorite, favoriteCategory);
            return;
        }
    }

    public void populateWith(IRecipeWrapper recipe, IRecipeCategory<?> category) {
        if (!Internal.getIngredientRegistry().isIngredientCraftable(this.ingredient)) {
            return;
        }
        this.recipe = recipe;
        this.category = category;
        Ingredients ingredients = new Ingredients();
        this.recipe.getIngredients(ingredients);
        this.inputs = new ObjectArrayList();
        for (IIngredientType type : ingredients.getInputIngredients().keySet()) {
            this.populateInputType(ingredients.getInputs(type));
        }
        this.outputAmount = 0L;
        for (IIngredientType<Object> other : ingredients.getOutputIngredients().get(Internal.getIngredientRegistry().getIngredientType(this.ingredient))) {
            if (!IngredientUtil.equals(this.ingredient, other)) continue;
            this.outputAmount += (long)IngredientUtil.getCount(other);
        }
        this.inputDummyItems = this.inputs.stream().map(input -> {
            long initialSize = input.amount;
            return new DummyBookmarkItem<I>(input.aliases.get(0), this.getGroup(), () -> initialSize * this.getMultiplier());
        }).collect(Collectors.toList());
    }

    public void populateSelf(RecipeChain chain) {
        this.populateWith(this.recipe, this.category);
        RecipeBookmarkItem<?> possibleSecondary = chain.findOutputWithSameRecipe(this);
        if (possibleSecondary != null) {
            this.secondaryTo = possibleSecondary;
        }
    }

    private <T> void populateInputType(List<List<T>> typeInputs) {
        int typeSize = typeInputs.size();
        boolean[] seen = new boolean[typeSize];
        for (int i = 0; i < typeSize; ++i) {
            List<T> inputAliases;
            if (seen[i] || (inputAliases = this.removeNulls(typeInputs.get(i))).isEmpty()) continue;
            int count = IngredientUtil.getCount(inputAliases.get(0));
            for (int j = i + 1; j < typeSize; ++j) {
                List<T> other = typeInputs.get(j);
                if (!IngredientUtil.aliasesEquals(inputAliases, other)) continue;
                count += IngredientUtil.getCount(other.get(0));
                seen[j] = true;
            }
            this.inputs.add(new RecipeBookmarkItem<T>(inputAliases, count));
        }
        this.inputs.forEach(input -> {
            input.foundAliases = true;
        });
    }

    private <T> List<T> removeNulls(List<T> original) {
        ObjectArrayList list = new ObjectArrayList(original.size());
        for (T item : original) {
            if (item == null) continue;
            list.add(item);
        }
        return list;
    }

    public boolean isPopulated() {
        return this.recipe != null;
    }

    @Override
    public boolean startsNewRow() {
        return this.secondaryTo == null && this.inputs != null;
    }

    public List<DummyBookmarkItem<?>> getInputs() {
        return this.inputDummyItems;
    }

    public long getMultiplier() {
        if (this.outputAmount == 0L) {
            return 0L;
        }
        return (this.amount + this.outputAmount - 1L) / this.outputAmount;
    }

    @Override
    public void changeAmount(long delta) {
        this.selfOutputAmount = (long)Math.round(this.selfOutputAmount / delta) * delta;
        this.selfOutputAmount += delta;
        this.selfOutputAmount = Math.max(0L, this.selfOutputAmount);
        if (this.getGroup() instanceof RecipeBookmarkGroup) {
            ((RecipeBookmarkGroup)this.getGroup()).update();
        }
    }

    public IRecipeLayout createLayout() {
        return RecipeLayout.create(-1, this.category, this.recipe, null, 0, 0);
    }

    @Override
    public long getDisplayAmount() {
        if (this.outputAmount == 0L) {
            return this.amount;
        }
        return this.outputAmount * this.getMultiplier();
    }

    @Override
    public boolean deserialize(NBTTagCompound serialized) {
        super.deserialize(serialized);
        this.selfOutputAmount = serialized.func_74763_f("selfOutputAmount");
        this.category = Internal.getRuntime().getRecipeRegistry().getRecipeCategory(serialized.func_74779_i("category"));
        this.recipe = Internal.getRuntime().getRecipeRegistry().getRecipeById(serialized.func_74763_f("recipe"), this.category);
        return this.category != null && this.recipe != null;
    }

    @Override
    public String serialize() {
        NBTTagCompound tag = this.getNBTOfIngredient(this.ingredient);
        tag.func_74772_a("amount", this.amount);
        tag.func_74772_a("selfOutputAmount", this.selfOutputAmount);
        tag.func_74778_a("category", this.category.getUid());
        tag.func_74772_a("recipe", Internal.getRuntime().getRecipeRegistry().getRecipeId(this.recipe));
        if (this.ingredient instanceof ItemStack) {
            return "RT:" + tag;
        }
        return "RO:" + tag;
    }

    @Override
    public void setGroup(BookmarkGroup group) {
        super.setGroup(group);
        if (this.inputDummyItems != null) {
            this.inputDummyItems.forEach(item -> item.setGroup(group));
        }
    }

    @Override
    public RecipeBookmarkItem<I> copy() {
        return new RecipeBookmarkItem<I>(this);
    }
}

