/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting.favorites;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.Internal;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.config.Config;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.util.Log;
import org.apache.commons.io.IOUtils;

public class FavoriteRecipes {
    private static final Map<String, IRecipeWrapper> ingredients = new Object2ObjectOpenHashMap();
    private static IngredientRegistry ingredientRegistry;
    private static RecipeRegistry recipeRegistry;
    private static final Object2ObjectOpenHashMap<IRecipeWrapper, IRecipeCategory<?>> recipeCategories;

    public static void load() {
        List strings;
        ingredients.clear();
        recipeCategories.clear();
        ingredientRegistry = Internal.getIngredientRegistry();
        recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        File file = Config.getFavoriteFile();
        if (file == null || !file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            strings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            Log.get().error("Failed to load favorite recipes from file {}", (Object)file, (Object)e);
            return;
        }
        Long2ObjectOpenHashMap rawRecipes = new Long2ObjectOpenHashMap(8192);
        IRecipeCategory currentCategory = null;
        RecipeRegistry recipeRegistry = Internal.getRuntime().getRecipeRegistry();
        for (String string : strings) {
            if (string.charAt(0) == '#') {
                FavoriteRecipes.addRecipesForCategory(currentCategory, (Long2ObjectMap<String>)rawRecipes, recipeRegistry);
                currentCategory = recipeRegistry.getRecipeCategory(string.substring(1));
                continue;
            }
            String[] split = string.split("%");
            long recipeIdString = Long.parseLong(split[0]);
            String ingredientString = split[1];
            rawRecipes.put(recipeIdString, (Object)ingredientString);
        }
        FavoriteRecipes.addRecipesForCategory(currentCategory, (Long2ObjectMap<String>)rawRecipes, recipeRegistry);
    }

    public static void addRecipesForCategory(IRecipeCategory<?> category, Long2ObjectMap<String> rawRecipes, RecipeRegistry recipeRegistry) {
        if (category != null && !rawRecipes.isEmpty()) {
            for (Long2ObjectMap.Entry entry : rawRecipes.long2ObjectEntrySet()) {
                IRecipeWrapper recipe = recipeRegistry.getRecipeById(entry.getLongKey(), category);
                if (recipe != null) {
                    ingredients.put((String)entry.getValue(), recipe);
                    recipeCategories.put((Object)recipe, category);
                    continue;
                }
                Log.get().warn("Could not find recipe with id {} in category {}!", (Object)entry.getLongKey(), (Object)category.getUid());
            }
        }
        rawRecipes.clear();
    }

    public static void save() {
        File file = Config.getFavoriteFile();
        ArrayList<String> strings = new ArrayList<String>();
        Map categoryMap = (Map)ingredients.entrySet().stream().collect(Object2ObjectOpenHashMap::new, (map, entry) -> {
            IRecipeCategory category = (IRecipeCategory)recipeCategories.get(entry.getValue());
            ((Map)map.computeIfAbsent((Object)category, k -> new Object2ObjectOpenHashMap())).put(entry.getKey(), entry.getValue());
        }, Object2ObjectOpenHashMap::putAll);
        for (Map.Entry categoryEntry : categoryMap.entrySet()) {
            strings.add("#" + ((IRecipeCategory)categoryEntry.getKey()).getUid());
            for (Map.Entry ingredientAndRecipe : ((Map)categoryEntry.getValue()).entrySet()) {
                strings.add(recipeRegistry.getRecipeId((IRecipeWrapper)ingredientAndRecipe.getValue()) + "%" + (String)ingredientAndRecipe.getKey());
            }
        }
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                Log.get().error("Failed to save favorite recipes to file {}", (Object)file, (Object)e);
            }
        }
    }

    public static boolean isFavorite(IRecipeWrapper recipe) {
        return ingredients.containsValue(recipe);
    }

    public static boolean isFavoriteFor(IRecipeWrapper recipe, Object ingredient) {
        return FavoriteRecipes.getFavorite(ingredient) == recipe;
    }

    public static void toggleFavorite(Object ingredient, IRecipeWrapper recipe, IRecipeCategory<?> category) {
        String id = ingredientRegistry.getIngredientHelper(ingredient).getUniqueId(ingredient);
        if (ingredients.containsKey(id) && ingredients.get(id) == recipe) {
            ingredients.remove(id);
        } else {
            ingredients.put(id, recipe);
            recipeCategories.put((Object)recipe, category);
        }
        FavoriteRecipes.save();
    }

    public static void removeFavorite(IRecipeWrapper data) {
        ingredients.entrySet().removeIf(entry -> entry.getValue() == data);
        FavoriteRecipes.save();
    }

    public static IRecipeWrapper getFavorite(Object ingredient) {
        String id = ingredientRegistry.getIngredientHelper(ingredient).getUniqueId(ingredient);
        return ingredients.get(id);
    }

    public static IRecipeCategory<?> getFavoriteCategory(Object ingredient) {
        IRecipeWrapper recipe = FavoriteRecipes.getFavorite(ingredient);
        return recipe != null ? (IRecipeCategory)recipeCategories.get((Object)recipe) : null;
    }

    static {
        recipeCategories = new Object2ObjectOpenHashMap(8192);
    }
}

