/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.api.IIngredientListOverlay;
import mezz.jei.api.gui.IGuiProperties;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.ghost.GhostIngredientDragManager;
import mezz.jei.gui.ghost.IGhostIngredientDragSource;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.ConfigButton;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.GuiProperties;
import mezz.jei.gui.overlay.IngredientGridWithNavigation;
import mezz.jei.gui.recipes.RecipesGui;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.CommandUtil;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class IngredientListOverlay
implements IIngredientListOverlay,
IMouseHandler,
IShowsRecipeFocuses,
IGhostIngredientDragSource {
    private static final int BORDER_PADDING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int SEARCH_HEIGHT = 20;
    private boolean hasRoom;
    private final IngredientFilter ingredientFilter;
    private final GuiIconToggleButton configButton;
    private final IngredientGridWithNavigation contents;
    private final GuiScreenHelper guiScreenHelper;
    private final GuiTextFieldFilter searchField;
    @Deprecated
    private final GhostIngredientDragManager ghostIngredientDragManager;
    private Rectangle displayArea = new Rectangle();
    @Nullable
    private IGuiProperties guiProperties;

    private static boolean isSearchBarCentered(IGuiProperties guiProperties) {
        return Config.isCenterSearchBarEnabled() && guiProperties.getGuiTop() + guiProperties.getGuiYSize() + 20 < guiProperties.getScreenHeight();
    }

    public IngredientListOverlay(IngredientFilter ingredientFilter, IngredientRegistry ingredientRegistry, GuiScreenHelper guiScreenHelper, GhostIngredientDragManager dragManager) {
        this.ingredientFilter = ingredientFilter;
        this.guiScreenHelper = guiScreenHelper;
        this.contents = new IngredientGridWithNavigation(ingredientFilter, guiScreenHelper, GridAlignment.LEFT);
        ingredientFilter.addListener(() -> this.onSetFilterText(Config.getFilterText()));
        this.searchField = new GuiTextFieldFilter(0, ingredientFilter);
        this.configButton = ConfigButton.create(this);
        this.ghostIngredientDragManager = dragManager;
        this.setKeyboardFocus(false);
    }

    public void rebuildItemFilter() {
        Log.get().info("Updating ingredient filter...");
        long start_time = System.currentTimeMillis();
        this.ingredientFilter.modesChanged();
        Log.get().info("Updated ingredient filter in {} ms", (Object)(System.currentTimeMillis() - start_time));
        this.updateLayout(true);
    }

    public void invalidateBuffer() {
        this.contents.invalidateBuffer();
    }

    public boolean isListDisplayed() {
        return Config.isOverlayEnabled() && this.guiProperties != null && this.hasRoom;
    }

    private static Rectangle getDisplayArea(IGuiProperties guiProperties) {
        int x = guiProperties.getGuiLeft() + guiProperties.getGuiXSize() + 2;
        int y = 2;
        int width = guiProperties.getScreenWidth() - x - 2;
        int height = guiProperties.getScreenHeight() - 2 - 2;
        return new Rectangle(x, 2, width, height);
    }

    public void updateScreen(@Nullable GuiScreen guiScreen, boolean forceUpdate) {
        boolean wasDisplayed = this.isListDisplayed();
        IGuiProperties guiProperties = this.guiScreenHelper.getGuiProperties(guiScreen);
        if (guiProperties == null) {
            if (this.guiProperties != null) {
                this.guiProperties = null;
                this.setKeyboardFocus(false);
            }
        } else if (forceUpdate || this.guiProperties == null || !GuiProperties.areEqual(this.guiProperties, guiProperties)) {
            this.guiProperties = guiProperties;
            this.displayArea = IngredientListOverlay.getDisplayArea(guiProperties);
            boolean searchBarCentered = IngredientListOverlay.isSearchBarCentered(guiProperties);
            int searchHeight = searchBarCentered ? 0 : 22;
            Set<Rectangle> guiExclusionAreas = this.guiScreenHelper.getGuiExclusionAreas();
            Rectangle availableContentsArea = new Rectangle(this.displayArea.x, this.displayArea.y, this.displayArea.width, this.displayArea.height - searchHeight);
            this.hasRoom = this.contents.updateBounds(availableContentsArea, guiExclusionAreas, 80);
            Rectangle contentsArea = this.contents.getArea();
            this.displayArea.x = contentsArea.x;
            this.displayArea.width = contentsArea.width;
            if (Config.hideBottomRightCornerConfigButton()) {
                if (searchBarCentered && this.isListDisplayed()) {
                    this.searchField.updateBounds(new Rectangle(guiProperties.getGuiLeft(), guiProperties.getScreenHeight() - 20 - 2, guiProperties.getGuiXSize() + 1, 20));
                } else {
                    this.searchField.updateBounds(new Rectangle(this.displayArea.x, this.displayArea.y + this.displayArea.height - 20 - 2, this.displayArea.width + 1, 20));
                }
            } else if (searchBarCentered && this.isListDisplayed()) {
                this.searchField.updateBounds(new Rectangle(guiProperties.getGuiLeft(), guiProperties.getScreenHeight() - 20 - 2, guiProperties.getGuiXSize() - 20 + 1, 20));
            } else {
                this.searchField.updateBounds(new Rectangle(this.displayArea.x, this.displayArea.y + this.displayArea.height - 20 - 2, this.displayArea.width - 20 + 1, 20));
            }
            if (Config.hideBottomRightCornerConfigButton()) {
                this.configButton.updateBounds(new Rectangle(this.searchField.field_146209_f + this.searchField.field_146218_h - 1, this.searchField.field_146210_g, 0, 0));
            } else {
                this.configButton.updateBounds(new Rectangle(this.searchField.field_146209_f + this.searchField.field_146218_h - 1, this.searchField.field_146210_g, 20, 20));
            }
            this.updateLayout(false);
        }
        if (wasDisplayed && !this.isListDisplayed()) {
            Config.saveFilterText();
        }
    }

    public void updateLayout(boolean filterChanged) {
        this.contents.updateLayout(filterChanged);
        this.searchField.update();
    }

    public void drawScreen(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.guiProperties != null) {
            if (this.isListDisplayed()) {
                GlStateManager.func_179140_f();
                this.searchField.func_146194_f();
                this.contents.draw(minecraft, mouseX, mouseY, partialTicks);
                if (!Config.hideBottomRightCornerConfigButton() || Config.isCenterSearchBarEnabled()) {
                    this.configButton.draw(minecraft, mouseX, mouseY, partialTicks);
                }
            } else if (!Config.hideBottomRightCornerConfigButton() || Config.isCenterSearchBarEnabled()) {
                this.configButton.draw(minecraft, mouseX, mouseY, partialTicks);
            }
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            if (!Config.hideBottomRightCornerConfigButton() || Config.isCenterSearchBarEnabled()) {
                this.configButton.drawTooltips(minecraft, mouseX, mouseY);
            }
            this.contents.drawTooltips(minecraft, mouseX, mouseY);
        } else if (this.guiProperties != null) {
            this.configButton.drawTooltips(minecraft, mouseX, mouseY);
        }
    }

    public void drawOnForeground(Minecraft minecraft, GuiContainer gui, int mouseX, int mouseY) {
    }

    public void handleTick() {
        if (this.isListDisplayed()) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.isListDisplayed()) {
            if (Config.isCenterSearchBarEnabled() && this.searchField.isMouseOver(mouseX, mouseY)) {
                return true;
            }
            return this.displayArea.contains(mouseX, mouseY);
        }
        if (this.guiProperties != null) {
            return this.configButton.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        IClickedIngredient<?> clicked;
        if (this.isListDisplayed() && (clicked = this.contents.getIngredientUnderMouse(mouseX, mouseY)) != null) {
            clicked.setOnClickHandler(() -> this.setKeyboardFocus(false));
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return this.isListDisplayed() && this.contents.canSetFocusWithMouse();
    }

    @Override
    public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.isListDisplayed()) {
            IClickedIngredient<?> clicked;
            if ((!Config.hideBottomRightCornerConfigButton() || Config.isCenterSearchBarEnabled()) && this.configButton.handleMouseClick(mouseX, mouseY)) {
                return true;
            }
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.setKeyboardFocus(false);
                return false;
            }
            if (this.contents.handleMouseClicked(mouseX, mouseY, mouseButton)) {
                this.setKeyboardFocus(false);
                return true;
            }
            boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
            this.setKeyboardFocus(searchClicked);
            if (searchClicked) {
                boolean updated = this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton);
                if (updated) {
                    this.updateLayout(false);
                }
                return true;
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            GuiScreen currentScreen = minecraft.field_71462_r;
            if (currentScreen != null && !(currentScreen instanceof RecipesGui) && (mouseButton == 0 || mouseButton == 1 || minecraft.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) && (clicked = this.getIngredientUnderMouse(mouseX, mouseY)) != null && Config.isCheatItemsEnabled()) {
                ItemStack clickWithStack = minecraft.field_71439_g.field_71071_by.func_70445_o();
                ItemStack itemStack = clicked.replaceWithCheatItemStack(clickWithStack);
                if (itemStack.func_190926_b()) {
                    itemStack = clicked.getCheatItemStack();
                }
                if (!itemStack.func_190926_b()) {
                    CommandUtil.giveStack(itemStack, mouseButton);
                }
                clicked.onClickHandled();
                return true;
            }
        } else if (this.guiProperties != null && (!Config.hideBottomRightCornerConfigButton() || Config.isCenterSearchBarEnabled())) {
            return this.configButton.handleMouseClick(mouseX, mouseY);
        }
        return false;
    }

    @Override
    public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
        return this.isListDisplayed() && this.isMouseOver(mouseX, mouseY) && this.contents.handleMouseScrolled(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean hasKeyboardFocus() {
        return this.isListDisplayed() && this.searchField.func_146206_l();
    }

    public void setKeyboardFocus(boolean keyboardFocus) {
        this.searchField.func_146195_b(keyboardFocus);
    }

    public boolean onGlobalKeyPressed(int eventKey) {
        if (this.isListDisplayed()) {
            if (KeyBindings.toggleCheatMode.isActiveAndMatches(eventKey)) {
                Config.toggleCheatItemsEnabled();
                return true;
            }
            if (KeyBindings.toggleEditMode.isActiveAndMatches(eventKey)) {
                Config.toggleEditModeEnabled();
                return true;
            }
            if (KeyBindings.focusSearch.isActiveAndMatches(eventKey)) {
                this.setKeyboardFocus(true);
                return true;
            }
        }
        return false;
    }

    public boolean onKeyPressed(char typedChar, int eventKey) {
        if (this.isListDisplayed()) {
            if (this.hasKeyboardFocus() && this.searchField.func_146201_a(typedChar, eventKey)) {
                boolean changed = Config.setFilterText(this.searchField.func_146179_b());
                if (changed) {
                    this.updateLayout(true);
                }
                return true;
            }
            return this.contents.onKeyPressed(typedChar, eventKey);
        }
        return false;
    }

    @Override
    @Nullable
    public Object getIngredientUnderMouse() {
        IIngredientListElement elementUnderMouse;
        if (this.isListDisplayed() && (elementUnderMouse = this.contents.getElementUnderMouse()) != null) {
            return elementUnderMouse.getIngredient();
        }
        return null;
    }

    public void onSetFilterText(String filterText) {
        this.searchField.func_146180_a(filterText);
        this.updateLayout(true);
    }

    @Override
    public ImmutableList<Object> getVisibleIngredients() {
        if (this.isListDisplayed()) {
            ImmutableList.Builder visibleIngredients = ImmutableList.builder();
            List<IIngredientListElement> visibleElements = this.contents.getVisibleElements();
            for (IIngredientListElement element : visibleElements) {
                Object ingredient = element.getIngredient();
                visibleIngredients.add(ingredient);
            }
            return visibleIngredients.build();
        }
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        return this.contents.getElementUnderMouse();
    }
}

