/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import java.io.IOException;
import java.util.EnumMap;
import javax.annotation.Nullable;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.IPacketJeiHandler;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import mezz.jei.util.Log;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class PacketHandler {
    public static final String CHANNEL_ID = "jei";
    public final EnumMap<PacketIdServer, IPacketJeiHandler> serverHandlers = new EnumMap(PacketIdServer.class);

    public PacketHandler() {
        this.serverHandlers.put(PacketIdServer.RECIPE_TRANSFER, PacketRecipeTransfer::readPacketData);
        this.serverHandlers.put(PacketIdServer.DELETE_ITEM, PacketDeletePlayerItem::readPacketData);
        this.serverHandlers.put(PacketIdServer.GIVE_ITEM, PacketGiveItemStack::readPacketData);
        this.serverHandlers.put(PacketIdServer.SET_HOTBAR_ITEM, PacketSetHotbarItemStack::readPacketData);
        this.serverHandlers.put(PacketIdServer.CHEAT_PERMISSION_REQUEST, PacketRequestCheatPermission::readPacketData);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        PacketBuffer packetBuffer = new PacketBuffer(event.getPacket().payload());
        EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
            IPacketJeiHandler packetHandler = this.serverHandlers.get(packetId);
            PacketHandler.checkThreadAndEnqueue(packetHandler, packetBuffer, (EntityPlayer)player, (IThreadListener)player.func_184102_h());
        }
        catch (RuntimeException ex) {
            Log.get().error("Packet error", (Throwable)ex);
        }
    }

    private static void checkThreadAndEnqueue(IPacketJeiHandler packetHandler, PacketBuffer packetBuffer, EntityPlayer player, @Nullable IThreadListener threadListener) {
        if (threadListener != null && !threadListener.func_152345_ab()) {
            threadListener.func_152344_a(() -> {
                try {
                    packetHandler.readPacketData(packetBuffer, player);
                }
                catch (IOException e) {
                    Log.get().error("Network Error", (Throwable)e);
                }
                finally {
                    packetBuffer.release();
                }
            });
        }
    }
}

