/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.fluid;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.color.ColorGetter;
import mezz.jei.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class FluidStackHelper
implements IIngredientHelper<FluidStack> {
    private final Map<FluidStack, Integer> hashCache = new Object2IntOpenHashMap();

    @Override
    @Nullable
    public FluidStack getMatch(Iterable<FluidStack> ingredients, FluidStack toMatch) {
        for (FluidStack fluidStack : ingredients) {
            if (toMatch.getFluid() != fluidStack.getFluid()) continue;
            return fluidStack;
        }
        return null;
    }

    @Override
    public String getDisplayName(FluidStack ingredient) {
        return ingredient.getLocalizedName();
    }

    @Override
    public String getUniqueId(FluidStack ingredient) {
        StringBuilder uniqueId = new StringBuilder("fluid:");
        uniqueId.append(ingredient.getFluid().getName());
        String subtype = Internal.getSubtypeRegistry().getSubtypeInfo(ingredient);
        if (subtype != null) {
            uniqueId.append(subtype);
        }
        return uniqueId.toString();
    }

    @Override
    public int getHash(FluidStack ingredient) {
        if (ingredient.amount == 0) {
            return 0;
        }
        if (this.hashCache.containsKey(ingredient)) {
            return this.hashCache.get(ingredient);
        }
        int hash = ingredient.amount * 31 + ingredient.getFluid().getName().hashCode();
        hash = hash * 31 + (ingredient.tag == null ? 0 : ingredient.tag.hashCode());
        this.hashCache.put(ingredient, hash);
        return hash;
    }

    @Override
    public String getWildcardId(FluidStack ingredient) {
        return this.getUniqueId(ingredient);
    }

    @Override
    public String getModId(FluidStack ingredient) {
        String defaultFluidName = FluidRegistry.getDefaultFluidName((Fluid)ingredient.getFluid());
        if (defaultFluidName == null) {
            return "";
        }
        ResourceLocation fluidResourceName = new ResourceLocation(defaultFluidName);
        return fluidResourceName.func_110624_b();
    }

    @Override
    public Iterable<Color> getColors(FluidStack ingredient) {
        TextureAtlasSprite fluidStillSprite;
        Fluid fluid = ingredient.getFluid();
        TextureMap textureMapBlocks = Minecraft.func_71410_x().func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        if (fluidStill != null && (fluidStillSprite = textureMapBlocks.getTextureExtry(fluidStill.toString())) != null) {
            int renderColor = ingredient.getFluid().getColor(ingredient);
            return ColorGetter.getColors(fluidStillSprite, renderColor, 1);
        }
        return Collections.emptyList();
    }

    @Override
    public String getResourceId(FluidStack ingredient) {
        String defaultFluidName = FluidRegistry.getDefaultFluidName((Fluid)ingredient.getFluid());
        if (defaultFluidName == null) {
            return "";
        }
        ResourceLocation fluidResourceName = new ResourceLocation(defaultFluidName);
        return fluidResourceName.func_110623_a();
    }

    @Override
    public ItemStack getCheatItemStack(FluidStack ingredient) {
        IFluidHandlerItem handler = (IFluidHandlerItem)Config.getDefaultFluidContainerItem().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        ingredient = ingredient.copy();
        ingredient.amount = Integer.MAX_VALUE;
        handler.fill(ingredient, true);
        return handler.getContainer();
    }

    @Override
    public ItemStack replaceWithCheatItemStack(FluidStack ingredient, ItemStack clickedWith) {
        if (clickedWith.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)clickedWith.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler != null) {
            clickedWith = clickedWith.func_77946_l();
            clickedWith.func_190920_e(1);
            handler = (IFluidHandlerItem)clickedWith.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            ingredient = ingredient.copy();
            ingredient.amount = Integer.MAX_VALUE;
            if (handler.fill(ingredient, true) > 0) {
                return handler.getContainer();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public FluidStack copyIngredient(FluidStack ingredient) {
        return ingredient.copy();
    }

    @Override
    public String getErrorInfo(@Nullable FluidStack ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(FluidStack.class);
        Fluid fluid = ingredient.getFluid();
        if (fluid != null) {
            toStringHelper.add("Fluid", (Object)fluid.getLocalizedName(ingredient));
        } else {
            toStringHelper.add("Fluid", (Object)"null");
        }
        toStringHelper.add("Amount", ingredient.amount);
        if (ingredient.tag != null) {
            toStringHelper.add("Tag", (Object)ingredient.tag);
        }
        return toStringHelper.toString();
    }
}

