/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.config.Config;
import mezz.jei.startup.AbstractModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.Log;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.StringUtils;

public class ForgeModIdHelper
extends AbstractModIdHelper {
    private static final String MOD_NAME_FORMAT_CODE = "%MODNAME%";
    @Nullable
    private static ForgeModIdHelper INSTANCE;
    private final Map<String, ModContainer> modMap = Loader.instance().getIndexedModList();

    public static IModIdHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ForgeModIdHelper();
        }
        return INSTANCE;
    }

    private ForgeModIdHelper() {
    }

    @Override
    public String getModNameForModId(String modId) {
        ModContainer modContainer = this.modMap.get(modId);
        if (modContainer == null) {
            return modId;
        }
        return modContainer.getName();
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modNameFormat = Config.getModNameFormat();
        if (modNameFormat.isEmpty()) {
            return null;
        }
        String modName = this.getModNameForModId(modId);
        modName = ForgeModIdHelper.removeChatFormatting(modName);
        if (modNameFormat.contains(MOD_NAME_FORMAT_CODE)) {
            return StringUtils.replaceOnce((String)modNameFormat, (String)MOD_NAME_FORMAT_CODE, (String)modName);
        }
        return modNameFormat + modName;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    @Override
    @Nullable
    public String getModNameTooltipFormatting() {
        try {
            ItemStack itemStack = new ItemStack(Items.field_151034_e);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            List tooltip = new ArrayList<String>();
            tooltip.add("HEI Tooltip Testing for mod name formatting");
            ItemTooltipEvent tooltipEvent = ForgeEventFactory.onItemTooltip((ItemStack)itemStack, (EntityPlayer)player, tooltip, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            tooltip = tooltipEvent.getToolTip();
            if (tooltip.size() > 1) {
                for (int lineNum = 1; lineNum < tooltip.size(); ++lineNum) {
                    String withoutFormatting;
                    String line = (String)tooltip.get(lineNum);
                    if (!line.contains("Minecraft") || (withoutFormatting = TextFormatting.func_110646_a((String)line)) == null) continue;
                    if (line.equals(withoutFormatting)) {
                        return "";
                    }
                    if (!line.contains(withoutFormatting)) continue;
                    return StringUtils.replaceOnce((String)line, (String)"Minecraft", (String)MOD_NAME_FORMAT_CODE);
                }
            }
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().error("Error while Testing for mod name formatting", e);
        }
        return null;
    }

    @Override
    public <T> List<String> addModNameToIngredientTooltip(List<String> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (Config.isDebugModeEnabled() && Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            tooltip = new ArrayList<String>(tooltip);
            tooltip.add(TextFormatting.GRAY + "HEI Debug:");
            tooltip.add(TextFormatting.GRAY + "info: " + ingredientHelper.getErrorInfo(ingredient));
            tooltip.add(TextFormatting.GRAY + "uid: " + ingredientHelper.getUniqueId(ingredient));
        }
        if (Config.isModNameFormatOverrideActive() && this.skipAddingModName(ingredient)) {
            return tooltip;
        }
        return super.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    private <T> boolean skipAddingModName(T ingredient) {
        if (ingredient instanceof ItemStack || ingredient instanceof EnchantmentData) {
            return true;
        }
        if (ingredient instanceof BookmarkItem) {
            return this.skipAddingModName(((BookmarkItem)ingredient).ingredient);
        }
        return false;
    }
}

