/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.JustEnoughItems;
import mezz.jei.network.packets.PacketCraftUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public final class BasicRecipeTransferHandlerServer {
    public static int itemsCrafted;

    private BasicRecipeTransferHandlerServer() {
    }

    public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, int maxTransfer, boolean requireCompleteSets, @Nullable Map<Integer, Integer> itemCounts) {
        Container container = player.field_71070_bA;
        HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
        for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
            Slot slot = container.func_75139_a(entry.getValue().intValue());
            ItemStack slotStack = slot.func_75211_c();
            if (slotStack.func_190926_b()) {
                return;
            }
            ItemStack stack = slotStack.func_77946_l();
            stack.func_190920_e(itemCounts == null ? 1 : itemCounts.get(entry.getKey()));
            slotMap.put(entry.getKey(), stack);
        }
        boolean transferAsCompleteSets = requireCompleteSets || maxTransfer != Integer.MAX_VALUE;
        Map<Integer, ItemStack> toTransfer = BasicRecipeTransferHandlerServer.removeItemsFromInventory(player, container, slotMap, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        if (toTransfer.isEmpty()) {
            return;
        }
        int minSlotStackLimit = Integer.MAX_VALUE;
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (int craftingSlotNumberIndex = 0; craftingSlotNumberIndex < craftingSlots.size(); ++craftingSlotNumberIndex) {
            ItemStack transferItem;
            int craftingSlotNumber = craftingSlots.get(craftingSlotNumberIndex);
            Slot craftingSlot = container.func_75139_a(craftingSlotNumber);
            if (craftingSlot.func_75216_d()) {
                ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
                clearedCraftingItems.add(craftingItem);
            }
            if (!requireCompleteSets || (transferItem = toTransfer.get(craftingSlotNumberIndex)) == null) continue;
            int slotStackLimit = craftingSlot.func_178170_b(transferItem);
            minSlotStackLimit = Math.min(slotStackLimit, minSlotStackLimit);
        }
        for (Map.Entry<Integer, ItemStack> entry : toTransfer.entrySet()) {
            ItemStack stack;
            Integer craftNumber = entry.getKey();
            Integer slotNumber = craftingSlots.get(craftNumber);
            Slot slot = container.func_75139_a(slotNumber.intValue());
            if (slot.func_75214_a(stack = entry.getValue())) {
                if (stack.func_190916_E() > minSlotStackLimit) {
                    ItemStack remainder = stack.func_77979_a(stack.func_190916_E() - minSlotStackLimit);
                    clearedCraftingItems.add(remainder);
                }
                slot.func_75215_d(stack);
                continue;
            }
            clearedCraftingItems.add(stack);
        }
        for (ItemStack oldCraftingItem : clearedCraftingItems) {
            int added = BasicRecipeTransferHandlerServer.addStack(container, inventorySlots, oldCraftingItem);
            if (added >= oldCraftingItem.func_190916_E()) continue;
            oldCraftingItem.func_190918_g(added);
            if (player.field_71071_by.func_70441_a(oldCraftingItem)) continue;
            player.func_71019_a(oldCraftingItem, false);
        }
        container.func_75142_b();
    }

    public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        BasicRecipeTransferHandlerServer.setItems(player, slotIdMap, craftingSlots, inventorySlots, maxTransfer ? Integer.MAX_VALUE : 1, requireCompleteSets, null);
    }

    public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, int maxTransfer, boolean requireCompleteSets) {
        BasicRecipeTransferHandlerServer.setItems(player, slotIdMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets, null);
    }

    @Nonnull
    private static Map<Integer, ItemStack> removeItemsFromInventory(EntityPlayer player, Container container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean transferAsCompleteSets, int maxTransfer) {
        HashMap<Integer, ItemStack> result;
        block8: {
            boolean noItemsFound;
            result = new HashMap<Integer, ItemStack>(required.size());
            int setsTransferred = 0;
            do {
                HashMap<Slot, ItemStack> originalSlotContents = null;
                if (transferAsCompleteSets) {
                    originalSlotContents = new HashMap<Slot, ItemStack>();
                }
                HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                noItemsFound = true;
                for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                    boolean resultItemStackLimitReached;
                    ItemStack requiredStack = entry.getValue().func_77946_l();
                    Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                    boolean itemFound = slot != null && !slot.func_75211_c().func_190926_b() && slot.func_82869_a(player);
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.func_190916_E() == resultItemStack.func_77976_d();
                    if (!itemFound || resultItemStackLimitReached) {
                        if (!transferAsCompleteSets) continue;
                        for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                            ItemStack stack = (ItemStack)slotEntry.getValue();
                            ((Slot)slotEntry.getKey()).func_75215_d(stack);
                        }
                        break block8;
                    }
                    if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                        originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                    }
                    ItemStack removedItemStack = slot.func_75209_a(entry.getValue().func_190916_E());
                    foundItemsInSet.put(entry.getKey(), removedItemStack);
                    noItemsFound = false;
                }
                for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                    ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                    if (resultItemStack == null) {
                        result.put(entry.getKey(), (ItemStack)entry.getValue());
                        continue;
                    }
                    resultItemStack.func_190917_f(((ItemStack)entry.getValue()).func_190916_E());
                }
            } while (!noItemsFound && ++setsTransferred < maxTransfer);
        }
        return result;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
        Slot slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
        if (slot == null) {
            slot = BasicRecipeTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
        }
        return slot;
    }

    private static int addStack(Container container, Collection<Integer> slotIndexes, ItemStack stack) {
        Slot slot;
        ItemStack inventoryStack;
        int added = 0;
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.field_75151_b.size() || (inventoryStack = (slot = container.func_75139_a(slotIndex.intValue())).func_75211_c()).func_190926_b() || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
            int remain = stack.func_190916_E() - added;
            int maxStackSize = Math.min(slot.func_178170_b(inventoryStack), inventoryStack.func_77976_d());
            int space = maxStackSize - inventoryStack.func_190916_E();
            if (space <= 0) continue;
            if (space >= remain) {
                inventoryStack.func_190917_f(remain);
                return stack.func_190916_E();
            }
            inventoryStack.func_190920_e(inventoryStack.func_77976_d());
            added += space;
        }
        if (added >= stack.func_190916_E()) {
            return added;
        }
        for (Integer slotIndex : slotIndexes) {
            if (slotIndex < 0 || slotIndex >= container.field_75151_b.size() || !(inventoryStack = (slot = container.func_75139_a(slotIndex.intValue())).func_75211_c()).func_190926_b()) continue;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(stack.func_190916_E() - added);
            slot.func_75215_d(stackToAdd);
            return stack.func_190916_E();
        }
        return added;
    }

    @Nullable
    private static Slot getSlotWithStack(Container container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
        for (Integer slotNumber : slotNumbers) {
            Slot slot;
            ItemStack slotStack;
            if (slotNumber < 0 || slotNumber >= container.field_75151_b.size() || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.func_75139_a(slotNumber.intValue())).func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)slotStack)) continue;
            return slot;
        }
        return null;
    }

    public static void performRecipe(EntityPlayer player, int outputSlot) {
        if (player.field_71070_bA == null) {
            return;
        }
        player.field_71070_bA.func_75130_a((IInventory)player.field_71071_by);
        ItemStack outputStack = player.field_71070_bA.func_75139_a(outputSlot).func_75211_c();
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        if (!outputStack.func_190926_b()) {
            itemsCrafted = 0;
            playerMP.field_71070_bA.func_184996_a(outputSlot, 0, ClickType.QUICK_MOVE, player);
            playerMP.func_71113_k();
            playerMP.field_71070_bA.func_75142_b();
            JustEnoughItems.getProxy().sendPacketToClient(new PacketCraftUpdate(true, itemsCrafted), playerMP);
            return;
        }
        playerMP.field_71070_bA.func_75142_b();
        JustEnoughItems.getProxy().sendPacketToClient(new PacketCraftUpdate(false, 0), playerMP);
    }
}

