/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.BlastFurnace")
public class BlastFurnace {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient input, int time, @Optional IItemStack slag) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        BlastFurnaceRecipe r = new BlastFurnaceRecipe(CraftTweakerHelper.toStack(output), oInput, time, CraftTweakerHelper.toStack(slag));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    @ZenMethod
    public static void addFuel(IIngredient input, int time) {
        Object oInput = CraftTweakerHelper.toObject(input);
        if (oInput == null) {
            return;
        }
        CraftTweakerAPI.apply((IAction)new AddFuel(oInput, time));
    }

    @ZenMethod
    public static void removeFuel(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveFuel(CraftTweakerHelper.toStack(output)));
    }

    private static class RemoveFuel
    implements IAction {
        private final ItemStack stack;
        BlastFurnaceRecipe.BlastFurnaceFuel removed;

        public RemoveFuel(ItemStack fuel) {
            this.stack = fuel;
        }

        public void apply() {
            Iterator<BlastFurnaceRecipe.BlastFurnaceFuel> it = BlastFurnaceRecipe.blastFuels.iterator();
            while (it.hasNext()) {
                BlastFurnaceRecipe.BlastFurnaceFuel e = it.next();
                if (!e.input.matchesItemStack(this.stack)) continue;
                this.removed = e;
                it.remove();
                break;
            }
        }

        public String describe() {
            return "Removing " + this.stack + " as Blast Furnace Fuel";
        }
    }

    private static class AddFuel
    implements IAction {
        private final Object fuel;
        private Object fuelRecipeKey;
        private final int burnTime;

        public AddFuel(Object fuel, int burnTime) {
            this.fuel = fuel;
            this.burnTime = burnTime;
        }

        public void apply() {
            this.fuelRecipeKey = BlastFurnaceRecipe.addBlastFuel(this.fuel, this.burnTime);
        }

        public String describe() {
            return "Adding " + (this.fuel instanceof ItemStack ? ((ItemStack)this.fuel).func_82833_r() : (String)this.fuel) + " as Blast Furnace Fuel";
        }
    }

    private static class RemoveAll
    implements IAction {
        List<BlastFurnaceRecipe> removedRecipes;

        public void apply() {
            this.removedRecipes = new ArrayList<BlastFurnaceRecipe>(BlastFurnaceRecipe.recipeList);
            BlastFurnaceRecipe.recipeList.clear();
        }

        public String describe() {
            return "Removing all Blast Furnace Recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<BlastFurnaceRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = BlastFurnaceRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Blast Furnace Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final BlastFurnaceRecipe recipe;

        public Add(BlastFurnaceRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            BlastFurnaceRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Blast Furnace Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

