/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.core.recipe;

import gr8pefish.ironbackpacks.api.IronBackpacksAPI;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.IBackpack;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackSpecialty;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IngredientBackpack
extends Ingredient {
    private final int packTier;
    private final BackpackSpecialty specialty;
    private final NonNullList<BackpackType> types;
    private IntList itemIds = null;
    private ItemStack[] items;

    public IngredientBackpack(int packTier, BackpackSpecialty specialty) {
        super(new ItemStack[0]);
        this.packTier = packTier;
        this.specialty = specialty;
        this.types = NonNullList.func_193580_a((Object)((Object)IronBackpacksAPI.getBackpackType(IronBackpacksAPI.NULL)), (Object[])IronBackpacksAPI.getBackpackTypes().stream().filter(b -> !b.getIdentifier().equals((Object)IronBackpacksAPI.NULL) && b.getTier() == packTier).collect(Collectors.toList()).toArray(new BackpackType[0]));
    }

    public IngredientBackpack(BackpackType type, BackpackSpecialty specialty) {
        this(type.getTier(), specialty);
    }

    public ItemStack[] func_193365_a() {
        if (this.items == null) {
            NonNullList stacks = NonNullList.func_191197_a((int)this.types.size(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < this.types.size(); ++i) {
                ItemStack stack = IronBackpacksAPI.getStack((BackpackType)((Object)this.types.get(i)), this.specialty);
                stacks.set(i, (Object)stack);
            }
            this.items = (ItemStack[])stacks.toArray((Object[])new ItemStack[0]);
        }
        return this.items;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IntList func_194139_b() {
        if (this.itemIds == null || this.itemIds.size() != this.types.size()) {
            this.itemIds = new IntArrayList(this.types.size());
            for (BackpackType type : this.types) {
                this.itemIds.add(RecipeItemHelper.func_194113_b((ItemStack)IronBackpacksAPI.getStack(type, this.specialty)));
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean apply(@Nullable ItemStack input) {
        if (input == null || input.func_190926_b()) {
            return false;
        }
        if (!input.func_77942_o()) {
            return false;
        }
        if (!(input.func_77973_b() instanceof IBackpack)) {
            return false;
        }
        BackpackInfo info = ((IBackpack)input.func_77973_b()).getBackpackInfo(input);
        return info.getVariant().getBackpackType().getTier() == this.packTier && info.getVariant().getBackpackSpecialty() == this.specialty;
    }

    protected void invalidate() {
        this.itemIds = null;
    }
}

