/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.supporters.BindPoint;
import goblinbob.mobends.core.util.Color;
import goblinbob.mobends.core.util.ColorAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class ConnectionHelper {
    public static ConnectionHelper INSTANCE = new ConnectionHelper();
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private Gson gson;

    private ConnectionHelper() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(Color.class, (Object)new ColorAdapter());
        builder.registerTypeAdapter(BindPoint.class, (Object)new BindPoint.Adapter());
        builder.registerTypeAdapter(AssetLocation.class, (Object)new AssetLocation.Adapter());
        this.gson = builder.create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public static <T> T sendGetRequest(URL url, Map<String, String> params, Class<T> responseClass) throws IOException, URISyntaxException {
        HttpGet request = new HttpGet();
        URIBuilder uriBuilder = new URIBuilder(url.toURI());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            uriBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        request.setURI(uriBuilder.build());
        try (CloseableHttpResponse response = ConnectionHelper.INSTANCE.httpClient.execute((HttpUriRequest)request);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Object object = ConnectionHelper.INSTANCE.gson.fromJson(EntityUtils.toString((HttpEntity)entity), responseClass);
                return (T)object;
            }
        }
        return null;
    }

    public static <T> T sendPostRequest(URL url, JsonObject body, Class<T> responseClass) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        byte[] out = new Gson().toJson((JsonElement)body).getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        connection.setFixedLengthStreamingMode(length);
        connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        connection.connect();
        try (OutputStream os = connection.getOutputStream();){
            os.write(out);
        }
        BufferedReader json = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        Object response = ConnectionHelper.INSTANCE.gson.fromJson((Reader)json, responseClass);
        return (T)response;
    }
}

