/*
 * Decompiled with CFR 0.152.
 */
package goblinbob.mobends.standard.client.renderer.entity.layers;

import goblinbob.mobends.core.asset.AssetLocation;
import goblinbob.mobends.core.asset.AssetModels;
import goblinbob.mobends.core.client.model.IModelPart;
import goblinbob.mobends.core.supporters.AccessoryDetails;
import goblinbob.mobends.core.supporters.AccessoryPart;
import goblinbob.mobends.core.supporters.AccessorySettings;
import goblinbob.mobends.core.supporters.BindPoint;
import goblinbob.mobends.core.supporters.SupporterContent;
import goblinbob.mobends.core.util.BenderHelper;
import goblinbob.mobends.core.util.Color;
import goblinbob.mobends.standard.data.PlayerData;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class LayerPlayerAccessories
implements LayerRenderer<AbstractClientPlayer> {
    private final RenderLivingBase<? extends AbstractClientPlayer> renderPlayer;
    private final RenderItem itemRenderer;
    private final ModelManager modelManager;
    private final TextureManager textureManager;
    private final ItemStack emptyItemStack = new ItemStack(Items.field_190931_a);

    public LayerPlayerAccessories(RenderLivingBase<? extends AbstractClientPlayer> renderPlayer) {
        Minecraft mc = Minecraft.func_71410_x();
        this.renderPlayer = renderPlayer;
        this.itemRenderer = mc.func_175599_af();
        this.modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        this.textureManager = mc.func_110434_K();
    }

    public void doRenderLayer(AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        Set<Map.Entry<String, AccessoryDetails>> accessories = SupporterContent.getAccessories();
        PlayerData data = (PlayerData)BenderHelper.getData(player, this.renderPlayer);
        assert (data != null);
        Map<String, AccessorySettings> settingsMap = SupporterContent.getAccessorySettingsMapFor((EntityLivingBase)player);
        for (Map.Entry<String, AccessoryDetails> entry : accessories) {
            AccessorySettings accessorySettings = settingsMap.getOrDefault(entry.getKey(), AccessorySettings.DEFAULT);
            this.renderAccessory(player, data, entry.getValue(), accessorySettings, scale);
        }
    }

    private void renderAccessory(AbstractClientPlayer player, PlayerData data, AccessoryDetails accessory, AccessorySettings settings, float scale) {
        if (!settings.isUnlocked() || settings.isHidden()) {
            return;
        }
        for (AccessoryPart part : accessory.getParts()) {
            this.renderPart(player, data, part, settings, scale);
        }
    }

    private void renderPart(AbstractClientPlayer player, PlayerData data, AccessoryPart part, AccessorySettings settings, float scale) {
        SimpleBakedModel simpleBakedModel = AssetModels.INSTANCE.getModel(part.getModelPath());
        if (simpleBakedModel == null) {
            return;
        }
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            if (player.field_71075_bZ.field_75100_b) {
                GlStateManager.func_179109_b((float)0.0f, (float)(4.0f * scale), (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)0.0f, (float)(3.0f * scale), (float)0.0f);
            }
        }
        this.applyBindPointTransform(data, part.getBindPoint(), scale);
        ItemTransformVec3f transformVec3f = simpleBakedModel.func_177552_f().field_178353_d;
        GlStateManager.func_179109_b((float)transformVec3f.field_178365_c.x, (float)transformVec3f.field_178365_c.y, (float)transformVec3f.field_178365_c.z);
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)transformVec3f.field_178364_b.z, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)transformVec3f.field_178363_d.x, (float)transformVec3f.field_178363_d.y, (float)transformVec3f.field_178363_d.z);
        this.textureManager.func_110577_a((ResourceLocation)part.getDiffuseTexturePath());
        this.drawModel((IBakedModel)simpleBakedModel, -1);
        AssetLocation inkedLocation = part.getInkedTexturePath();
        if (inkedLocation != null) {
            this.textureManager.func_110577_a((ResourceLocation)inkedLocation);
            GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
            this.drawModel((IBakedModel)simpleBakedModel, Color.asHex(settings.getColor()));
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179121_F();
    }

    private void drawModel(IBakedModel model, int color) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.itemRenderer.func_191970_a(bufferbuilder, model.func_188616_a(null, enumfacing, 0L), color, this.emptyItemStack);
        }
        this.itemRenderer.func_191970_a(bufferbuilder, model.func_188616_a(null, null, 0L), color, this.emptyItemStack);
        tessellator.func_78381_a();
    }

    private void applyBindPointTransform(PlayerData data, BindPoint bindPoint, float scale) {
        IModelPart modelPart = bindPoint.getPartSelector().apply(data);
        if (modelPart != null) {
            modelPart.applyCharacterTransform(scale);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

