/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.mixin.optifine;

import java.util.HashSet;
import java.util.Set;
import meldexun.nothirium.mc.integration.Optifine;
import meldexun.nothirium.mc.renderer.ChunkRenderManager;
import meldexun.nothirium.renderer.chunk.AbstractRenderChunk;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"net.optifine.DynamicLight"}, remap=false)
public class MixinDynamicLight {
    @Shadow
    private Entity entity;
    @Shadow
    private double offsetY;
    @Shadow
    private double lastPosX;
    @Shadow
    private double lastPosY;
    @Shadow
    private double lastPosZ;
    @Shadow
    private int lastLightLevel;
    @Shadow
    private boolean underwater;
    @Shadow
    private long timeCheckMs;
    @Shadow
    private Set<BlockPos> setLitChunkPos;
    @Shadow
    private BlockPos.MutableBlockPos blockPosMutable;

    @Inject(method={"update"}, remap=false, require=1, cancellable=true, at={@At(value="HEAD")})
    private void on_getWorldFromBlockAccess(RenderGlobal renderGlobal, CallbackInfo info) {
        info.cancel();
        if (((Boolean)Optifine.IS_DYNAMIC_LIGHTS_FAST.invoke(null, new Object[0])).booleanValue()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.field_70165_t - 0.5;
        double posY = this.entity.field_70163_u - 0.5 + this.offsetY;
        double posZ = this.entity.field_70161_v - 0.5;
        int lightLevel = (Integer)Optifine.GET_LIGHT_LEVEL.invoke(null, new Object[]{this.entity});
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (dx * dx + dy * dy + dz * dz <= delta * delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            this.blockPosMutable.func_189532_c(posX, posY, posZ);
            IBlockState state = world.func_180495_p((BlockPos)this.blockPosMutable);
            this.underwater = state.func_185904_a() == Material.field_151586_h;
        } else {
            this.underwater = false;
        }
        HashSet<BlockPos> setNewPos = new HashSet<BlockPos>();
        if (lightLevel > 0) {
            EnumFacing dirX = (MathHelper.func_76128_c((double)posX) & 0xF) >= 8 ? EnumFacing.EAST : EnumFacing.WEST;
            EnumFacing dirY = (MathHelper.func_76128_c((double)posY) & 0xF) >= 8 ? EnumFacing.UP : EnumFacing.DOWN;
            EnumFacing dirZ = (MathHelper.func_76128_c((double)posZ) & 0xF) >= 8 ? EnumFacing.SOUTH : EnumFacing.NORTH;
            BlockPos chunkPos = new BlockPos(posX, posY, posZ);
            BlockPos chunkPosX = chunkPos.func_177967_a(dirX, 16);
            BlockPos chunkPosY = chunkPos.func_177967_a(dirY, 16);
            BlockPos chunkPosZ = chunkPos.func_177967_a(dirZ, 16);
            BlockPos chunkPosXY = chunkPosX.func_177967_a(dirY, 16);
            BlockPos chunkPosXZ = chunkPosX.func_177967_a(dirZ, 16);
            BlockPos chunkPosYZ = chunkPosY.func_177967_a(dirZ, 16);
            BlockPos chunkPosXYZ = chunkPosXY.func_177967_a(dirZ, 16);
            this.updateChunkLight(renderGlobal, chunkPos, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosXY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(renderGlobal, chunkPosXYZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    @Unique
    private void updateChunkLight(RenderGlobal renderGlobal, BlockPos pos, Set<BlockPos> setPrevPos, Set<BlockPos> setNewPos) {
        Object provider = ChunkRenderManager.getProvider();
        Object chunk = provider.getRenderChunkAt(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
        if (chunk != null) {
            ((AbstractRenderChunk)chunk).markDirty();
        }
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    @Unique
    private void updateLitChunks(RenderGlobal renderGlobal) {
        for (BlockPos posOld : this.setLitChunkPos) {
            this.updateChunkLight(renderGlobal, posOld, null, null);
        }
    }

    @Inject(method={"updateLitChunks"}, remap=false, require=1, cancellable=true, at={@At(value="HEAD")})
    private void on_updateLitChunks(RenderGlobal renderGlobal, CallbackInfo info) {
        info.cancel();
        this.updateLitChunks(renderGlobal);
    }
}

