/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import meldexun.matrixutil.Matrix4f;
import meldexun.nothirium.api.renderer.IVBOPart;
import meldexun.nothirium.api.renderer.chunk.ChunkRenderPass;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkProvider;
import meldexun.nothirium.mc.config.NothiriumConfig;
import meldexun.nothirium.mc.renderer.chunk.ChunkRendererDynamicVbo;
import meldexun.nothirium.mc.renderer.chunk.RenderChunk;
import meldexun.nothirium.mc.util.FogUtil;
import meldexun.nothirium.mc.util.ResourceSupplier;
import meldexun.nothirium.opengl.DynamicVBO;
import meldexun.nothirium.util.ListUtil;
import meldexun.nothirium.util.collection.Enum2IntMap;
import meldexun.nothirium.util.collection.Enum2ObjMap;
import meldexun.nothirium.util.collection.IntMultiObject;
import meldexun.nothirium.util.collection.MultiObject;
import meldexun.renderlib.util.Frustum;
import meldexun.renderlib.util.GLBuffer;
import meldexun.renderlib.util.GLShader;
import meldexun.renderlib.util.GLUtil;
import meldexun.renderlib.util.RenderUtil;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL42;

public class ChunkRendererGL42
extends ChunkRendererDynamicVbo {
    private static final String A_POS = "a_Pos";
    private static final String A_COLOR = "a_Color";
    private static final String A_TEXCOORD = "a_TexCoord";
    private static final String A_LIGHTCOORD = "a_LightCoord";
    private static final String A_OFFSET = "a_Offset";
    private static final String U_BLOCKTEX = "u_BlockTex";
    private static final String U_LIGHTTEX = "u_LightTex";
    private static final String U_MATRIX = "u_ModelViewProjectionMatrix";
    private final GLShader shader = new GLShader.Builder().addShader(35633, (Supplier)new ResourceSupplier(new ResourceLocation("nothirium", "shaders/chunk_vert.glsl"))).addShader(35632, (Supplier)new ResourceSupplier(new ResourceLocation("nothirium", "shaders/chunk_frag.glsl"))).bindAttribute("a_Pos", 0).bindAttribute("a_Color", 1).bindAttribute("a_TexCoord", 2).bindAttribute("a_LightCoord", 3).bindAttribute("a_Offset", 4).build(p -> {
        GL20.glUniform1i((int)p.getUniform(U_BLOCKTEX), (int)0);
        GL20.glUniform1i((int)p.getUniform(U_LIGHTTEX), (int)1);
    });
    private final MultiObject<Enum2IntMap<ChunkRenderPass>> vaos;
    private final MultiObject<Enum2ObjMap<ChunkRenderPass, GLBuffer>> offsetBuffers;
    private final IntMultiObject syncs;

    public ChunkRendererGL42() {
        this(2);
    }

    public ChunkRendererGL42(int bufferCount) {
        this.vaos = new MultiObject<Enum2IntMap>(bufferCount, i -> new Enum2IntMap<ChunkRenderPass>(ChunkRenderPass.class));
        this.offsetBuffers = new MultiObject<Enum2ObjMap>(bufferCount, i -> new Enum2ObjMap(ChunkRenderPass.class));
        this.syncs = new IntMultiObject(bufferCount, i -> -1);
        this.vbos.forEach((pass, vbo) -> vbo.addListener(() -> this.initVAOs((ChunkRenderPass)((Object)pass))));
    }

    @Override
    public NothiriumConfig.RenderEngine getRenderEngine() {
        return NothiriumConfig.RenderEngine.GL42;
    }

    @Override
    public String name() {
        return "Nothirium GL 4.2";
    }

    @Override
    public void init(int renderDistance) {
        int d = renderDistance * 2 + 1;
        int renderDistance3 = d * d * d;
        this.offsetBuffers.stream().flatMap(Enum2ObjMap::stream).filter(Objects::nonNull).forEach(GLBuffer::dispose);
        this.offsetBuffers.forEach(e -> e.fill(pass -> new GLBuffer((long)(renderDistance3 * 12), 2, 35040, true, 2)));
        Arrays.stream(ChunkRenderPass.ALL).forEach(this::initVAOs);
    }

    private void initVAOs(ChunkRenderPass pass) {
        this.vaos.forEach((i, e) -> {
            GL30.glDeleteVertexArrays((int)e.getInt(pass));
            int vao = GL30.glGenVertexArrays();
            GL30.glBindVertexArray((int)vao);
            GL15.glBindBuffer((int)34962, (int)((DynamicVBO)this.vbos.get(pass)).getVbo());
            GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_POS), (int)3, (int)5126, (boolean)false, (int)28, (long)0L);
            GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_COLOR), (int)4, (int)5121, (boolean)true, (int)28, (long)12L);
            GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_TEXCOORD), (int)2, (int)5126, (boolean)false, (int)28, (long)16L);
            GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_LIGHTCOORD), (int)2, (int)5122, (boolean)false, (int)28, (long)24L);
            GL15.glBindBuffer((int)34962, (int)this.offsetBuffers.get(i).get(pass).getBuffer());
            GL20.glVertexAttribPointer((int)this.shader.getAttribute(A_OFFSET), (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
            GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_POS));
            GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_COLOR));
            GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_TEXCOORD));
            GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_LIGHTCOORD));
            GL20.glEnableVertexAttribArray((int)this.shader.getAttribute(A_OFFSET));
            GL33.glVertexAttribDivisor((int)this.shader.getAttribute(A_OFFSET), (int)1);
            GL15.glBindBuffer((int)34962, (int)0);
            GL30.glBindVertexArray((int)0);
            e.set(pass, vao);
        });
    }

    @Override
    public void setup(IRenderChunkProvider<RenderChunk> renderChunkProvider, double cameraX, double cameraY, double cameraZ, Frustum frustum, int frame) {
        super.setup(renderChunkProvider, cameraX, cameraY, cameraZ, frustum, frame);
        this.vaos.update();
        this.offsetBuffers.update();
        this.syncs.update();
        this.offsetBuffers.get().forEach(b -> b.map(2, 35001));
        if (this.syncs.getInt() != -1) {
            GL33.glGetQueryObjecti64((int)this.syncs.getInt(), (int)34918);
            GL15.glDeleteQueries((int)this.syncs.getInt());
            this.syncs.set(-1);
        }
        this.chunks.forEach((pass, list) -> ListUtil.forEach(list, pass == ChunkRenderPass.TRANSLUCENT, (renderChunk, i) -> this.record((RenderChunk)renderChunk, (ChunkRenderPass)((Object)pass), i, cameraX, cameraY, cameraZ)));
        this.offsetBuffers.get().forEach(GLBuffer::unmap);
    }

    protected void record(RenderChunk renderChunk, ChunkRenderPass pass, int index, double cameraX, double cameraY, double cameraZ) {
        GLBuffer offsetBuffer = this.offsetBuffers.get().get(pass);
        offsetBuffer.putFloat((long)(index * 12), (float)((double)renderChunk.getX() - cameraX));
        offsetBuffer.putFloat((long)(index * 12 + 4), (float)((double)renderChunk.getY() - cameraY));
        offsetBuffer.putFloat((long)(index * 12 + 8), (float)((double)renderChunk.getZ() - cameraZ));
    }

    @Override
    protected void renderChunks(ChunkRenderPass pass) {
        GLShader.push();
        this.shader.use();
        Matrix4f matrix = RenderUtil.getProjectionModelViewMatrix().copy();
        matrix.translate((float)RenderUtil.getCameraOffsetX(), (float)RenderUtil.getCameraOffsetY(), (float)RenderUtil.getCameraOffsetZ());
        GLUtil.setMatrix((int)this.shader.getUniform(U_MATRIX), (Matrix4f)matrix);
        FogUtil.setupFogFromGL(this.shader);
        GL30.glBindVertexArray((int)this.vaos.get().getInt(pass));
        ListUtil.forEach((List)this.chunks.get(pass), pass == ChunkRenderPass.TRANSLUCENT, (renderChunk, i) -> {
            IVBOPart vboPart = renderChunk.getVBOPart(pass);
            GL42.glDrawArraysInstancedBaseInstance((int)7, (int)vboPart.getFirst(), (int)vboPart.getCount(), (int)1, (int)i);
        });
        if (pass == ChunkRenderPass.TRANSLUCENT) {
            if (this.syncs.getInt() != -1) {
                GL15.glDeleteQueries((int)this.syncs.getInt());
            }
            int query = GL15.glGenQueries();
            GL33.glQueryCounter((int)query, (int)36392);
            this.syncs.set(query);
        }
        GL30.glBindVertexArray((int)0);
        GLShader.pop();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.shader.dispose();
        this.offsetBuffers.stream().flatMap(Enum2ObjMap::stream).filter(Objects::nonNull).forEach(GLBuffer::dispose);
        this.vaos.stream().flatMapToInt(Enum2IntMap::streamInt).forEach(GL30::glDeleteVertexArrays);
        this.syncs.streamInt().filter(i -> i != -1).forEach(GL15::glDeleteQueries);
    }
}

