/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.vertex;

import meldexun.memoryutil.UnsafeUtil;
import meldexun.nothirium.mc.vertex.ExtendedBufferBuilder;
import meldexun.nothirium.mc.vertex.VertexConsumer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import sun.misc.Unsafe;

public class NormalUploader {
    private static final VertexConsumer FLOAT = new VertexConsumer(){

        @Override
        public void normal(ExtendedBufferBuilder buffer, float x, float y, float z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, x);
            unsafe.putFloat(address + 4L, y);
            unsafe.putFloat(address + 8L, z);
        }
    };
    private static final VertexConsumer INT = new VertexConsumer(){

        @Override
        public void normal(ExtendedBufferBuilder buffer, float x, float y, float z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putInt(address, (int)x);
            unsafe.putInt(address + 4L, (int)y);
            unsafe.putInt(address + 8L, (int)z);
        }
    };
    private static final VertexConsumer SHORT = new VertexConsumer(){

        @Override
        public void normal(ExtendedBufferBuilder buffer, float x, float y, float z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putShort(address, (short)((int)(x * 32767.0f) & 0xFFFF));
            unsafe.putShort(address + 2L, (short)((int)(y * 32767.0f) & 0xFFFF));
            unsafe.putShort(address + 4L, (short)((int)(z * 32767.0f) & 0xFFFF));
        }
    };
    private static final VertexConsumer BYTE = new VertexConsumer(){

        @Override
        public void normal(ExtendedBufferBuilder buffer, float x, float y, float z) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)((int)(x * 127.0f) & 0xFF));
            unsafe.putByte(address + 1L, (byte)((int)(y * 127.0f) & 0xFF));
            unsafe.putByte(address + 2L, (byte)((int)(z * 127.0f) & 0xFF));
        }
    };

    public static VertexConsumer fromType(VertexFormatElement.EnumType type) {
        switch (type) {
            case FLOAT: {
                return FLOAT;
            }
            case UINT: 
            case INT: {
                return INT;
            }
            case USHORT: 
            case SHORT: {
                return SHORT;
            }
            case UBYTE: 
            case BYTE: {
                return BYTE;
            }
        }
        return null;
    }
}

