/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.opengl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import meldexun.nothirium.api.renderer.IVBOPart;
import meldexun.nothirium.opengl.GLHelper;
import meldexun.nothirium.util.SectorizedList;
import meldexun.nothirium.util.math.MathUtil;
import org.lwjgl.opengl.GL15;

public class DynamicVBO {
    private final int vertexSize;
    private final int vertexCountPerSector;
    private final int sectorSize;
    private final SectorizedList sectors;
    private int vbo;
    private final List<Runnable> listeners = new ArrayList<Runnable>();

    public DynamicVBO(int vertexSize, int vertexCountPerSector, int sectorCount) {
        this.vertexSize = vertexSize;
        this.vertexCountPerSector = vertexCountPerSector;
        this.sectorSize = vertexCountPerSector * vertexSize;
        this.sectors = new SectorizedList(sectorCount){

            @Override
            protected void grow(int minContinousSector) {
                int oldSectorCount = this.getSectorCount();
                super.grow(minContinousSector);
                int newVbo = GLHelper.growBuffer(DynamicVBO.this.vbo, (long)DynamicVBO.this.sectorSize * (long)oldSectorCount, (long)DynamicVBO.this.sectorSize * (long)this.getSectorCount());
                if (newVbo != DynamicVBO.this.vbo) {
                    DynamicVBO.this.vbo = newVbo;
                    DynamicVBO.this.listeners.forEach(Runnable::run);
                }
            }
        };
        this.vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (long)((long)this.sectorSize * (long)sectorCount), (int)35040);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    public VBOPart buffer(ByteBuffer data) {
        int size = data.limit();
        int requiredSectors = MathUtil.ceilDiv(size, this.sectorSize);
        if (requiredSectors <= 0) {
            throw new IllegalArgumentException();
        }
        SectorizedList.Sector sector = this.sectors.claim(requiredSectors);
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferSubData((int)34962, (long)((long)this.sectorSize * (long)sector.getFirstSector()), (ByteBuffer)data);
        GL15.glBindBuffer((int)34962, (int)0);
        return new VBOPart(sector, size / this.vertexSize);
    }

    public void free(SectorizedList.Sector sector) {
        this.sectors.free(sector);
    }

    public int getVbo() {
        return this.vbo;
    }

    public void dispose() {
        GL15.glDeleteBuffers((int)this.vbo);
    }

    public class VBOPart
    implements IVBOPart {
        private final SectorizedList.Sector sector;
        private final int vertexFirst;
        private final int vertexCount;
        private boolean valid = true;

        private VBOPart(SectorizedList.Sector sector, int vertexCount) {
            this.sector = sector;
            this.vertexFirst = sector.getFirstSector() * DynamicVBO.this.vertexCountPerSector;
            this.vertexCount = vertexCount;
        }

        @Override
        public int getVBO() {
            return DynamicVBO.this.vbo;
        }

        @Override
        public int getFirst() {
            return this.vertexFirst;
        }

        @Override
        public int getCount() {
            return this.vertexCount;
        }

        @Override
        public int getOffset() {
            return this.vertexFirst * DynamicVBO.this.vertexSize;
        }

        @Override
        public int getSize() {
            return this.vertexCount * DynamicVBO.this.vertexSize;
        }

        @Override
        public void free() {
            if (this.valid) {
                DynamicVBO.this.free(this.sector);
                this.valid = false;
            }
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }
    }
}

