/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util;

import meldexun.nothirium.util.FreeSectorManager;

public class SectorizedList {
    private int sectorCount;
    private Sector firstSector;
    private Sector lastSector;
    private final FreeSectorManager freeSectors = new FreeSectorManager.RB();

    public SectorizedList(int sectorCount) {
        this.sectorCount = sectorCount;
        this.lastSector = this.firstSector = new Sector(false, 0, sectorCount);
        this.freeSectors.add(this.firstSector);
    }

    protected void ensureCapacity(int minContinousSector) {
        if (minContinousSector <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.freeSectors.largestSector() < minContinousSector) {
            this.grow(minContinousSector);
        }
    }

    protected void grow(int minContinousSector) {
        int oldCapacity = this.sectorCount;
        int lastFreeSectorStart = !this.lastSector.claimed ? this.lastSector.firstSector : oldCapacity;
        this.sectorCount = this.calculateNewCapacity(oldCapacity, lastFreeSectorStart, minContinousSector);
        if (!this.lastSector.claimed) {
            this.freeSectors.siftUp(this.lastSector, s -> {
                Sector sector = s;
                sector.sectorCount = sector.sectorCount + (this.sectorCount - oldCapacity);
            });
        } else {
            Sector sector = new Sector(false, oldCapacity, this.sectorCount - oldCapacity);
            this.lastSector.next = sector;
            sector.prev = this.lastSector;
            this.lastSector = sector;
            this.freeSectors.add(sector);
        }
    }

    protected int calculateNewCapacity(int oldCapacity, int lastFreeSectorStart, int minContinousSector) {
        int newCapacity = oldCapacity;
        while (newCapacity - lastFreeSectorStart < minContinousSector) {
            newCapacity += newCapacity >> 1;
        }
        return newCapacity;
    }

    public Sector claim(int sectorCount) {
        if (sectorCount <= 0) {
            throw new IllegalArgumentException();
        }
        this.ensureCapacity(sectorCount);
        Sector freeSector = this.freeSectors.get(sectorCount);
        Sector sector = new Sector(true, freeSector.firstSector, sectorCount);
        Sector prev = freeSector.prev;
        Sector next = freeSector.next;
        if (freeSector.sectorCount == sectorCount) {
            this.freeSectors.remove(freeSector);
            if (prev != null) {
                sector.prev = prev;
                prev.next = sector;
            } else {
                this.firstSector = sector;
            }
            if (next != null) {
                sector.next = next;
                next.prev = sector;
            } else {
                this.lastSector = sector;
            }
        } else {
            this.freeSectors.siftDown(freeSector, s -> {
                Sector sector = s;
                sector.firstSector = sector.firstSector + sectorCount;
                sector = s;
                sector.sectorCount = sector.sectorCount - sectorCount;
            });
            if (prev != null) {
                sector.prev = prev;
                prev.next = sector;
            } else {
                this.firstSector = sector;
            }
            sector.next = freeSector;
            freeSector.prev = sector;
        }
        return sector;
    }

    public void free(Sector sector) {
        boolean nextFree;
        if (!sector.claimed) {
            throw new IllegalArgumentException();
        }
        sector.claimed = false;
        Sector prev = sector.prev;
        Sector next = sector.next;
        boolean prevFree = prev != null && !prev.claimed;
        boolean bl = nextFree = next != null && !next.claimed;
        if (prevFree) {
            if (nextFree) {
                this.freeSectors.remove(next);
                this.freeSectors.siftUp(prev, s -> {
                    Sector sector2 = s;
                    sector2.sectorCount = sector2.sectorCount + sector.sectorCount;
                    sector2 = s;
                    sector2.sectorCount = sector2.sectorCount + next.sectorCount;
                });
                prev.next = next.next;
                if (next.next != null) {
                    next.next.prev = prev;
                } else {
                    this.lastSector = prev;
                }
            } else {
                this.freeSectors.siftUp(prev, s -> {
                    Sector sector2 = s;
                    sector2.sectorCount = sector2.sectorCount + sector.sectorCount;
                });
                prev.next = next;
                if (next != null) {
                    next.prev = prev;
                } else {
                    this.lastSector = prev;
                }
            }
        } else if (nextFree) {
            this.freeSectors.siftUp(next, s -> {
                ((Sector)s).firstSector = sector.firstSector;
                Sector sector2 = s;
                sector2.sectorCount = sector2.sectorCount + sector.sectorCount;
            });
            next.prev = prev;
            if (prev != null) {
                prev.next = next;
            } else {
                this.firstSector = next;
            }
        } else {
            this.freeSectors.add(sector);
        }
    }

    public int getSectorCount() {
        return this.sectorCount;
    }

    public static class Sector
    implements Comparable<Sector> {
        private boolean claimed;
        private int firstSector;
        private int sectorCount;
        private Sector prev;
        private Sector next;

        private Sector(boolean claimed, int firstSector, int sectorCount) {
            this.claimed = claimed;
            this.firstSector = firstSector;
            this.sectorCount = sectorCount;
        }

        public String toString() {
            return String.format("%s(%d -> %d)", this.claimed ? "Claimed" : "Free", this.firstSector, this.firstSector + this.sectorCount - 1);
        }

        @Override
        public int compareTo(Sector o) {
            if (this.sectorCount < o.sectorCount) {
                return -1;
            }
            if (this.sectorCount > o.sectorCount) {
                return 1;
            }
            if (this.firstSector < o.firstSector) {
                return -1;
            }
            if (this.firstSector > o.firstSector) {
                return 1;
            }
            return 0;
        }

        public int getFirstSector() {
            return this.firstSector;
        }

        public int getSectorCount() {
            return this.sectorCount;
        }
    }
}

