/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.cache;

import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.IntFunction;

public class ArrayCache<T> {
    private final Queue<T[]> cache = new ConcurrentLinkedQueue<T[]>();
    private final int arraySize;
    private final IntFunction<T[]> supplier;
    private final T filler;

    public ArrayCache(int arraySize, IntFunction<T[]> supplier, T filler) {
        this.arraySize = arraySize;
        this.supplier = supplier;
        this.filler = filler;
    }

    public T[] get() {
        T[] a = this.cache.poll();
        if (a == null) {
            a = this.supplier.apply(this.arraySize);
            Arrays.fill(a, this.filler);
        }
        return a;
    }

    public void free(T[] t) {
        Arrays.fill(t, this.filler);
        this.cache.offer(t);
    }
}

