/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.util.collection;

import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import meldexun.nothirium.util.collection.IEnumMap;

public class Enum2ObjMap<E extends Enum<E>, T>
implements IEnumMap<E, T> {
    private final E[] enums;
    private final Object[] values;

    public Enum2ObjMap(Class<E> enumClass) {
        this.enums = (Enum[])enumClass.getEnumConstants();
        this.values = new Object[this.enums.length];
    }

    public Enum2ObjMap(Class<E> enumClass, Function<E, T> mapper) {
        this(enumClass);
        this.fill(mapper);
    }

    public Enum2ObjMap(Class<E> enumClass, Supplier<T> mapper) {
        this(enumClass);
        this.fill(mapper);
    }

    @Override
    public T get(E e) {
        return (T)this.values[((Enum)e).ordinal()];
    }

    @Override
    public void set(E e, T t) {
        this.values[((Enum)e).ordinal()] = t;
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.values, 1040), false);
    }

    @Override
    public void forEach(BiConsumer<E, T> action) {
        for (E e : this.enums) {
            action.accept(e, this.values[((Enum)e).ordinal()]);
        }
    }

    @Override
    public void forEach(Consumer<T> action) {
        for (Object t : this.values) {
            action.accept(t);
        }
    }

    @Override
    public void fill(Function<E, T> mapper) {
        for (E e : this.enums) {
            this.values[((Enum)e).ordinal()] = mapper.apply(e);
        }
    }

    @Override
    public void fill(Supplier<T> mapper) {
        for (E e : this.enums) {
            this.values[((Enum)e).ordinal()] = mapper.get();
        }
    }
}

