/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="jeid", name="RoughlyEnoughIDs")
@Config.LangKey(value="cfg.reid.mainTitle")
public class ConfigHandler {
    @Config.LangKey(value="cfg.reid.debug")
    @Config.Name(value="Debug")
    public static final DebugCategory DEBUG = new DebugCategory();
    @Config.LangKey(value="cfg.reid.transformer")
    @Config.Name(value="Transformers")
    public static final TransformerCategory TRANSFORMER = new TransformerCategory();

    @Mod.EventBusSubscriber(modid="jeid")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("jeid")) {
                ConfigManager.sync((String)"jeid", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class TransformerCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Patch Targets: Chunk biome initialization")
        @Config.Comment(value={"Some mods may generate chunks outside of the expected class and need REID to inject its biome initialization.", "The issue generally manifests as random patches of plains biomes in chunks.", "Specify classes here by their fully qualified class name."})
        public String[] chunkBiomeInitPatchList = new String[]{"pregenerator.impl.processor.generator.ChunkHelper"};
    }

    public static class DebugCategory {
        @Config.RequiresMcRestart
        @Config.Name(value="Biomes")
        @Config.Comment(value={"Enable this to register extra biomes for debugging/testing."})
        public boolean reidDebugBiomesToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Biomes - Amount")
        @Config.Comment(value={"The amount of biomes to register."})
        public int reidDebugBiomesAmt = 300;
        @Config.RequiresMcRestart
        @Config.Name(value="Blocks")
        @Config.Comment(value={"Enable this to register extra blocks for debugging/testing."})
        public boolean reidDebugBlocksToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Blocks - Amount")
        @Config.Comment(value={"The amount of blocks to register."})
        public int reidDebugBlocksAmt = 5000;
        @Config.RequiresMcRestart
        @Config.Name(value="Enchantments")
        @Config.Comment(value={"Enable this to register extra enchantments for debugging/testing."})
        public boolean reidDebugEnchantsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Enchantments - Amount")
        @Config.Comment(value={"The amount of enchantments to register."})
        public int reidDebugEnchantsAmt = Short.MAX_VALUE;
        @Config.RequiresMcRestart
        @Config.Name(value="Items")
        @Config.Comment(value={"Enable this to register extra items for debugging/testing."})
        public boolean reidDebugItemsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Items - Amount")
        @Config.Comment(value={"The amount of items to register."})
        public int reidDebugItemsAmt = 40000;
        @Config.RequiresMcRestart
        @Config.Name(value="Potions")
        @Config.Comment(value={"Enable this to register extra potions for debugging/testing."})
        public boolean reidDebugPotionsToggle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="Potions - Amount")
        @Config.Comment(value={"The amount of potions to register."})
        public int reidDebugPotionsAmt = 300;
    }
}

