/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.core;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.dimdev.jeid.JEIDLogger;
import org.dimdev.jeid.config.ConfigHandler;
import org.dimdev.jeid.core.ChunkBiomeInjector;
import org.dimdev.jeid.core.JEIDLoadingPlugin;
import org.dimdev.jeid.util.ASMException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class JEIDTransformer
implements IClassTransformer {
    private final Map<String, Function<byte[], byte[]>> transformations = new HashMap<String, Function<byte[], byte[]>>();

    public JEIDTransformer() {
        this.addTransformation("net.minecraft.item.ItemStack", this::patchItemEnchantTag);
        this.addTransformation("net.minecraft.potion.PotionEffect", this::patchPotionTag);
        this.addTransformation("net.minecraft.world.gen.ChunkProviderServer", ChunkBiomeInjector::injectBiomeArrayInit);
        for (String extraTarget : ConfigHandler.TRANSFORMER.chunkBiomeInitPatchList) {
            this.addTransformation(extraTarget, ChunkBiomeInjector::injectBiomeArrayInit);
        }
    }

    public void addTransformation(String key, Function<byte[], byte[]> value) {
        JEIDLogger.LOGGER.info("Adding class {} to the transformation queue", (Object)key);
        this.transformations.put(key, value);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        Function<byte[], byte[]> transform = this.transformations.get(transformedName);
        if (transform != null) {
            return transform.apply(basicClass);
        }
        return basicClass;
    }

    private static MethodNode locateMethod(ClassNode cn, String desc, String ... namesIn) {
        return cn.methods.stream().filter(n -> n.desc.equals(desc) && JEIDTransformer.anyMatch(namesIn, n.name)).findAny().orElseThrow(() -> new ASMException(JEIDTransformer.getNames(namesIn) + ": " + desc + " cannot be found in " + cn.name, cn));
    }

    private static boolean anyMatch(String[] pool, String match) {
        for (String s : pool) {
            if (!s.equals(match)) continue;
            return true;
        }
        return false;
    }

    private static String getNames(String[] pool) {
        StringBuilder sb = new StringBuilder();
        for (String s : pool) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private static AbstractInsnNode locateTargetInsn(MethodNode mn, Predicate<AbstractInsnNode> filter) {
        AbstractInsnNode target = null;
        ListIterator i = mn.instructions.iterator();
        while (i.hasNext() && target == null) {
            AbstractInsnNode n = (AbstractInsnNode)i.next();
            if (!filter.test(n)) continue;
            target = n;
        }
        if (target == null) {
            throw new ASMException("Can't locate target instruction in " + mn.name, mn);
        }
        return target;
    }

    private byte[] patchItemEnchantTag(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        String enchantment = "net/minecraft/enchantment/Enchantment";
        String nbtTagCompound = "net/minecraft/nbt/NBTTagCompound";
        MethodNode mn = JEIDTransformer.locateMethod(cn, "(L" + enchantment + ";I)V", "addEnchantment", "func_77966_a");
        mn.instructions.remove(JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 147));
        AbstractInsnNode target2 = JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 182 && n.getPrevious().getPrevious().getPrevious().getOpcode() == 18 && ((LdcInsnNode)n.getPrevious().getPrevious().getPrevious()).cst.toString().equals("id"));
        mn.instructions.insertBefore(target2, (AbstractInsnNode)new MethodInsnNode(182, nbtTagCompound, JEIDLoadingPlugin.isDeobf ? "setInteger" : "func_74768_a", "(Ljava/lang/String;I)V", false));
        mn.instructions.remove(target2);
        if (FMLLaunchHandler.side().isClient()) {
            MethodNode mn2 = JEIDTransformer.locateMethod(cn, "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/client/util/ITooltipFlag;)Ljava/util/List;", "getTooltip", "func_82840_a");
            AbstractInsnNode target = JEIDTransformer.locateTargetInsn(mn2, n -> n.getOpcode() == 182 && n.getPrevious().getOpcode() == 18 && ((LdcInsnNode)n.getPrevious()).cst.toString().equals("id"));
            mn.instructions.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(182, nbtTagCompound, JEIDLoadingPlugin.isDeobf ? "getInteger" : "func_74762_e", "(Ljava/lang/String;)I", false));
            mn.instructions.remove(target);
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchPotionTag(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        String nbtTagCompound = "net/minecraft/nbt/NBTTagCompound";
        String potionEffect = "net/minecraft/potion/PotionEffect";
        MethodNode mn = JEIDTransformer.locateMethod(cn, "(L" + nbtTagCompound + ";)L" + nbtTagCompound + ";", "writeCustomPotionEffectToNBT", "func_82719_a");
        AbstractInsnNode ant = JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 145);
        MethodInsnNode call = new MethodInsnNode(182, nbtTagCompound, JEIDLoadingPlugin.isDeobf ? "setInteger" : "func_74768_a", "(Ljava/lang/String;I)V", false);
        mn.instructions.remove(ant.getNext());
        mn.instructions.insert(ant, (AbstractInsnNode)call);
        mn.instructions.remove(ant);
        MethodNode mn2 = JEIDTransformer.locateMethod(cn, "(L" + nbtTagCompound + ";)L" + potionEffect + ";", "readCustomPotionEffectFromNBT", "func_82722_b");
        AbstractInsnNode ant2 = JEIDTransformer.locateTargetInsn(mn2, n -> n.getOpcode() == 182);
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.insert(ant2, (AbstractInsnNode)new MethodInsnNode(182, nbtTagCompound, JEIDLoadingPlugin.isDeobf ? "getInteger" : "func_74762_e", "(Ljava/lang/String;)I", false));
        mn2.instructions.remove(ant2);
        ClassWriter cw = new ClassWriter(1);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

