/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.debug;

import java.util.Random;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.dimdev.jeid.config.ConfigHandler;
import org.dimdev.jeid.debug.DebugBase;

public class DebugPotion
extends DebugBase<Potion> {
    private final IForgeRegistry<PotionType> typeRegistry = GameRegistry.findRegistry(PotionType.class);

    public DebugPotion(int numInstances, IForgeRegistry<Potion> registry) {
        super(numInstances, registry);
    }

    @Override
    public void makeInstance(int id) {
        Potion instance = (Potion)new PotionTest(id).setRegistryName(new ResourceLocation("jeid", "potion_" + id));
        PotionType instanceType = (PotionType)new PotionType(new PotionEffect[]{new PotionEffect(instance, 2000, 0, false, true)}).setRegistryName(new ResourceLocation("jeid", "potiontype_" + id));
        this.registry.register((IForgeRegistryEntry)instance);
        this.typeRegistry.register((IForgeRegistryEntry)instanceType);
    }

    @Override
    public boolean shouldDebug() {
        return ConfigHandler.DEBUG.reidDebugPotionsToggle;
    }

    private static class PotionTest
    extends Potion {
        private static final Random r = new Random();
        private final String nm;

        protected PotionTest(int id) {
            super(false, 0xFFFFFF & r.nextInt(Integer.MAX_VALUE));
            this.nm = "Test Potion #" + id;
        }

        public String func_76393_a() {
            return this.nm;
        }
    }
}

