/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.debug;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.dimdev.jeid.debug.DebugBiome;
import org.dimdev.jeid.debug.DebugBlock;
import org.dimdev.jeid.debug.DebugEnchant;
import org.dimdev.jeid.debug.DebugItem;
import org.dimdev.jeid.debug.DebugPotion;
import org.dimdev.jeid.debug.IDebugClass;
import org.dimdev.jeid.debug.NumInstances;

public class RegistryDebug {
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        DebugBlock debugBlocks = new DebugBlock(NumInstances.BLOCK.value, (IForgeRegistry<Block>)event.getRegistry());
        if (debugBlocks.shouldDebug()) {
            this.makeAllInstances(debugBlocks);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        DebugItem debugItems = new DebugItem(NumInstances.ITEM.value, (IForgeRegistry<Item>)event.getRegistry());
        if (debugItems.shouldDebug()) {
            this.makeAllInstances(debugItems);
        }
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        DebugBiome debugBiomes = new DebugBiome(NumInstances.BIOME.value, (IForgeRegistry<Biome>)event.getRegistry());
        if (debugBiomes.shouldDebug()) {
            this.makeAllInstances(debugBiomes);
        }
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        DebugPotion debugPotions = new DebugPotion(NumInstances.POTION.value, (IForgeRegistry<Potion>)event.getRegistry());
        if (debugPotions.shouldDebug()) {
            this.makeAllInstances(debugPotions);
        }
    }

    @SubscribeEvent
    public void registerEnchants(RegistryEvent.Register<Enchantment> event) {
        DebugEnchant debugEnchants = new DebugEnchant(NumInstances.ENCHANT.value, (IForgeRegistry<Enchantment>)event.getRegistry());
        if (debugEnchants.shouldDebug()) {
            this.makeAllInstances(debugEnchants);
        }
    }

    private void makeAllInstances(IDebugClass debugClass) {
        for (int i = 0; i < debugClass.getNumInstances(); ++i) {
            debugClass.makeInstance(i);
        }
    }
}

