/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.mixin.modsupport.cubicchunks;

import io.github.opencubicchunks.cubicchunks.api.util.Coords;
import io.github.opencubicchunks.cubicchunks.core.CubicChunks;
import io.github.opencubicchunks.cubicchunks.core.util.AddressTools;
import io.github.opencubicchunks.cubicchunks.core.world.cube.Cube;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.dimdev.jeid.biome.BiomeError;
import org.dimdev.jeid.ducks.modsupport.cubicchunks.INewCube;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cube.class}, remap=false)
@Implements(value={@Interface(iface=INewCube.class, prefix="int$")})
public abstract class MixinCube {
    @Shadow
    @Final
    private World world;
    @Unique
    private static final byte ERROR_BIOME_ID = (byte)Biome.field_185377_q.func_148757_b((Object)BiomeError.getInstance());
    @Unique
    @Nullable
    private int[] intBiomeArray;

    @Shadow
    public abstract <T extends Chunk> T getColumn();

    @Overwrite
    public Biome getBiome(BlockPos pos) {
        if (this.intBiomeArray == null) {
            return this.getColumn().func_177411_a(pos, this.world.func_72959_q());
        }
        int biomeX = Coords.blockToLocalBiome3d((int)pos.func_177958_n());
        int biomeY = Coords.blockToLocalBiome3d((int)pos.func_177956_o());
        int biomeZ = Coords.blockToLocalBiome3d((int)pos.func_177952_p());
        int biomeId = this.intBiomeArray[AddressTools.getBiomeAddress3d((int)biomeX, (int)biomeY, (int)biomeZ)];
        return Biome.func_150568_d((int)biomeId);
    }

    @Inject(method={"getBiomeArray"}, at={@At(value="RETURN")}, cancellable=true)
    private void reid$returnErrorBiomeArray(CallbackInfoReturnable<byte[]> cir) {
        byte[] arr = new byte[256];
        Arrays.fill(arr, ERROR_BIOME_ID);
        cir.setReturnValue((Object)arr);
    }

    @Overwrite
    public void setBiome(int localBiomeX, int localBiomeY, int localBiomeZ, Biome biome) {
        if (this.intBiomeArray == null) {
            this.intBiomeArray = new int[64];
        }
        this.intBiomeArray[AddressTools.getBiomeAddress3d((int)localBiomeX, (int)localBiomeY, (int)localBiomeZ)] = Biome.field_185377_q.func_148757_b((Object)biome);
    }

    @Nullable
    public int[] int$getBiomeArray() {
        return this.intBiomeArray;
    }

    public void int$setBiomeArray(int[] biomeArray) {
        if (this.intBiomeArray == null) {
            this.intBiomeArray = biomeArray;
        }
        if (this.intBiomeArray.length != biomeArray.length) {
            CubicChunks.LOGGER.warn("Could not set level cube biomes, array length is {} instead of {}", (Object)biomeArray.length, (Object)this.intBiomeArray.length);
        } else {
            System.arraycopy(biomeArray, 0, this.intBiomeArray, 0, this.intBiomeArray.length);
        }
    }
}

