/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.dimdev.jeid.ducks.INewChunk;

public class BiomeAreaChangeMessage
implements IMessage {
    private int x;
    private int z;
    private int radius;
    private int biomeId;

    public BiomeAreaChangeMessage() {
    }

    public BiomeAreaChangeMessage(int x, int z, int radius, int biomeId) {
        this.x = x;
        this.z = z;
        this.radius = radius;
        this.biomeId = biomeId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        PacketBuffer packetBuffer = new PacketBuffer(byteBuf);
        this.x = packetBuffer.func_150792_a();
        this.z = packetBuffer.func_150792_a();
        this.radius = packetBuffer.func_150792_a();
        this.biomeId = packetBuffer.func_150792_a();
    }

    public void toBytes(ByteBuf byteBuf) {
        PacketBuffer packetBuffer = new PacketBuffer(byteBuf);
        packetBuffer.func_150787_b(this.x);
        packetBuffer.func_150787_b(this.z);
        packetBuffer.func_150787_b(this.radius);
        packetBuffer.func_150787_b(this.biomeId);
    }

    public static class Handler
    implements IMessageHandler<BiomeAreaChangeMessage, IMessage> {
        public IMessage onMessage(BiomeAreaChangeMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                int x = message.x;
                int z = message.z;
                int rad = message.radius;
                for (int ix = x - rad; ix <= x + rad; ++ix) {
                    for (int iz = z - rad; iz <= z + rad; ++iz) {
                        Chunk chunk = world.func_175726_f(new BlockPos(ix, 0, iz));
                        int[] biomeArray = ((INewChunk)chunk).getIntBiomeArray();
                        int biomeIdAtPos = biomeArray[(iz & 0xF) << 4 | ix & 0xF];
                        if (biomeIdAtPos == message.biomeId) continue;
                        biomeArray[(iz & 0xF) << 4 | ix & 0xF] = message.biomeId;
                    }
                }
                world.func_175704_b(new BlockPos(x - rad, 0, z - rad), new BlockPos(x + rad, world.func_72800_K(), z + rad));
            });
            return null;
        }
    }
}

