/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid.network;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.dimdev.jeid.network.BiomeAreaChangeMessage;
import org.dimdev.jeid.network.BiomeChunkChangeMessage;
import org.dimdev.jeid.network.BiomePositionChangeMessage;

public class MessageManager {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("jeid");

    public static void init() {
        CHANNEL.registerMessage(BiomeChunkChangeMessage.Handler.class, BiomeChunkChangeMessage.class, 0, Side.CLIENT);
        CHANNEL.registerMessage(BiomePositionChangeMessage.Handler.class, BiomePositionChangeMessage.class, 1, Side.CLIENT);
        CHANNEL.registerMessage(BiomeAreaChangeMessage.Handler.class, BiomeAreaChangeMessage.class, 2, Side.CLIENT);
    }

    public static void sendClientsBiomePosChange(World world, BlockPos pos, int biomeId) {
        CHANNEL.sendToAllTracking((IMessage)new BiomePositionChangeMessage(pos.func_177958_n(), pos.func_177952_p(), biomeId), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
    }

    public static void sendClientsBiomeAreaChange(World world, BlockPos pos, int radius, int biomeId) {
        CHANNEL.sendToAllTracking((IMessage)new BiomeAreaChangeMessage(pos.func_177958_n(), pos.func_177952_p(), radius, biomeId), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
    }

    public static void sendClientsBiomeChunkChange(World world, BlockPos pos, int[] biomeArr) {
        CHANNEL.sendToAllTracking((IMessage)new BiomeChunkChangeMessage(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, biomeArr), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
    }
}

