/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api;

import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.silentchaos512.gems.api.IGearItem;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.lib.EnumToolType;
import net.silentchaos512.gems.util.ToolHelper;

public interface ITool
extends IGearItem {
    public ItemStack constructTool(ItemStack var1, ItemStack ... var2);

    default public float getMeleeDamage(ItemStack tool) {
        return this.getMeleeDamageModifier() + ToolHelper.getMeleeDamage(tool);
    }

    default public float getMagicDamage(ItemStack tool) {
        return this.getMagicDamageModifier() + ToolHelper.getMagicDamage(tool);
    }

    public float getMeleeDamageModifier();

    public float getMagicDamageModifier();

    public float getMeleeSpeedModifier();

    default public float getHarvestSpeedMultiplier() {
        return 1.0f;
    }

    default public float getDurabilityMultiplier() {
        return 1.0f;
    }

    default public float getRepairMultiplier() {
        return 1.0f;
    }

    default public boolean isDiggingTool() {
        return false;
    }

    @Deprecated
    default public boolean isSuperTool() {
        return false;
    }

    @Deprecated
    default public Material[] getExtraEffectiveMaterials() {
        return new Material[0];
    }

    default public Material[] getExtraEffectiveMaterials(ItemStack tool) {
        return new Material[0];
    }

    @Override
    default public EnumToolType getToolType() {
        if (this instanceof ItemSword) {
            return EnumToolType.SWORD;
        }
        if (this instanceof ItemTool) {
            return EnumToolType.HARVEST;
        }
        if (this instanceof ItemBow) {
            return EnumToolType.BOW;
        }
        return EnumToolType.NONE;
    }

    default public boolean isDigger(ItemStack stack) {
        return this instanceof ItemTool;
    }

    default public boolean isCaster(ItemStack stack) {
        return this instanceof ItemGemSword && ToolHelper.getToolTier(stack).ordinal() >= EnumMaterialTier.SUPER.ordinal();
    }
}

