/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class Skulls {
    static Map<Class<? extends EntityLivingBase>, SkullInfo> map = new HashMap<Class<? extends EntityLivingBase>, SkullInfo>();
    static List<ItemStack> mobSkulls = new ArrayList<ItemStack>();
    static List<ItemStack> playerSkulls = new ArrayList<ItemStack>();
    static boolean initialized = false;

    public static ItemStack getPlayerSkull(EntityPlayer player) {
        return Skulls.getPlayerSkull(player.func_70005_c_());
    }

    public static ItemStack getPlayerSkull(String playerName) {
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
        skull.func_77982_d(new NBTTagCompound());
        skull.func_77978_p().func_74778_a("SkullOwner", playerName);
        return skull;
    }

    public static ItemStack getSkull(EntityLivingBase entity) {
        return Skulls.getSkull(entity.getClass());
    }

    public static ItemStack getSkull(Class<? extends EntityLivingBase> entityClass) {
        SkullInfo skullInfo = map.get(entityClass);
        if (skullInfo == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = skullInfo.stack;
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        return stack.func_77946_l();
    }

    public static ItemStack selectRandom(Random random) {
        if (random.nextFloat() < 0.25f) {
            return playerSkulls.get(random.nextInt(playerSkulls.size()));
        }
        return mobSkulls.get(random.nextInt(mobSkulls.size()));
    }

    public static float getDropRate(EntityLivingBase entity) {
        return Skulls.getDropRate(entity.getClass());
    }

    public static float getDropRate(Class<? extends EntityLivingBase> entityClass) {
        SkullInfo skullInfo = map.get(entityClass);
        if (skullInfo == null) {
            return 0.0f;
        }
        return skullInfo.dropRate;
    }

    public static void put(Class<? extends EntityLivingBase> entityClass, ItemStack skull, float dropRate) {
        SkullInfo info = new SkullInfo();
        info.stack = skull;
        info.dropRate = dropRate;
        map.put(entityClass, info);
        mobSkulls.add(skull);
    }

    public static void putPlayer(String playerName) {
        playerSkulls.add(Skulls.getPlayerSkull(playerName));
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        Skulls.put(EntitySkeleton.class, new ItemStack(Items.field_151144_bL, 1, 0), 0.1f);
        Skulls.put(EntityWitherSkeleton.class, new ItemStack(Items.field_151144_bL, 1, 1), 0.1f);
        Skulls.put(EntityZombie.class, new ItemStack(Items.field_151144_bL, 1, 2), 0.1f);
        Skulls.put(EntityPlayer.class, new ItemStack(Items.field_151144_bL, 1, 3), 0.5f);
        Skulls.put(EntityCreeper.class, new ItemStack(Items.field_151144_bL, 1, 4), 0.05f);
        Skulls.putPlayer("SilentChaos512");
        Skulls.putPlayer("ChaoticPlayz");
        Skulls.putPlayer("M4thG33k");
        Skulls.putPlayer("notch");
        Skulls.putPlayer("MHF_Alex");
        Skulls.putPlayer("MHF_Blaze");
        Skulls.putPlayer("MHF_CaveSpider");
        Skulls.putPlayer("MHF_Chicken");
        Skulls.putPlayer("MHF_Cow");
        Skulls.putPlayer("MHF_Enderman");
        Skulls.putPlayer("MHF_Ghast");
        Skulls.putPlayer("MHF_Golem");
        Skulls.putPlayer("MHF_Herobrine");
        Skulls.putPlayer("MHF_LavaSlime");
        Skulls.putPlayer("MHF_MushroomCow");
        Skulls.putPlayer("MHF_Ocelot");
        Skulls.putPlayer("MHF_Pig");
        Skulls.putPlayer("MHF_PigZombie");
        Skulls.putPlayer("MHF_Sheep");
        Skulls.putPlayer("MHF_Slime");
        Skulls.putPlayer("MHF_Spider");
        Skulls.putPlayer("MHF_Squid");
        Skulls.putPlayer("MHF_Steve");
        Skulls.putPlayer("MHF_Villager");
    }

    static class SkullInfo {
        float dropRate;
        ItemStack stack;

        SkullInfo() {
        }
    }
}

