/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.lib;

import javax.annotation.Nullable;
import net.silentchaos512.gems.api.lib.IPartPosition;

public enum ArmorPartPosition implements IPartPosition
{
    WEST(0, "Part1", "DecoWest"),
    NORTH(1, "Part0", "DecoNorth"),
    EAST(2, "Part2", "DecoEast"),
    SOUTH(3, "Part3", "DecoSouth"),
    FRAME(4, "PartFrame", "");

    final int renderPass;
    final String nbtKey;
    final String decoNbtKey;

    private ArmorPartPosition(int renderPass, String nbtKey, String decoNbtKey) {
        this.renderPass = renderPass;
        this.nbtKey = nbtKey;
        this.decoNbtKey = decoNbtKey;
    }

    @Nullable
    public static ArmorPartPosition forRenderPass(int pass) {
        for (ArmorPartPosition pos : ArmorPartPosition.values()) {
            if (pos.renderPass != pass) continue;
            return pos;
        }
        return null;
    }

    @Override
    public int getRenderPass() {
        return this.renderPass;
    }

    @Override
    public String getKey(int subPosition) {
        if (this.nbtKey.contains("%d")) {
            return String.format(this.nbtKey, subPosition);
        }
        return this.nbtKey;
    }

    @Override
    public String getDecoKey() {
        return this.decoNbtKey;
    }
}

