/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.lib;

import javax.annotation.Nullable;
import net.silentchaos512.gems.api.lib.IPartPosition;

public enum ToolPartPosition implements IPartPosition
{
    ROD(0, "PartRod", "DecoRod"),
    HEAD(1, "Part%d", "DecoHeadM"),
    TIP(2, "PartHeadTip", ""),
    ROD_DECO(3, "PartRodDeco", "PartRodDeco"),
    ROD_GRIP(4, "PartRodWool", "");

    final int renderPass;
    final String nbtKey;
    final String decoNbtKey;

    private ToolPartPosition(int renderPass, String nbtKey, String decoNbtKey) {
        this.renderPass = renderPass;
        this.nbtKey = nbtKey;
        this.decoNbtKey = decoNbtKey;
    }

    @Nullable
    public static ToolPartPosition forRenderPass(int pass) {
        for (ToolPartPosition pos : ToolPartPosition.values()) {
            if (pos.renderPass != pass) continue;
            return pos;
        }
        return null;
    }

    @Override
    public int getRenderPass() {
        return this.renderPass;
    }

    @Override
    public String getKey(int subPosition) {
        if (this.nbtKey.contains("%d")) {
            return String.format(this.nbtKey, subPosition);
        }
        return this.nbtKey;
    }

    @Override
    public String getDecoKey() {
        return this.decoNbtKey;
    }
}

