/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.stats.PartStats;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.ToolRenderHelper;

public abstract class ToolPart {
    @Nonnull
    protected String key;
    @Nonnull
    protected ItemStack craftingStack;
    @Nonnull
    protected String craftingOreDictName;
    protected EnumMaterialTier tier;
    protected int rarity;
    protected PartStats stats;

    public ToolPart(String key, ItemStack craftingStack) {
        this(key, craftingStack, "");
    }

    protected ToolPart(String key, ItemStack craftingStack, String craftingOreDictName) {
        this.key = key.toLowerCase();
        this.craftingStack = craftingStack;
        this.craftingOreDictName = craftingOreDictName;
        this.tier = EnumMaterialTier.REGULAR;
    }

    void setStatsFromOldMethods() {
        if (this.stats == null) {
            this.stats = new PartStats();
            this.stats.armor = this.getProtection();
            this.stats.attackSpeed = this.getMeleeSpeed();
            this.stats.chargeSpeed = this.getChargeSpeed();
            this.stats.durability = this.getDurability();
            this.stats.enchantablity = this.getEnchantability();
            this.stats.harvestLevel = this.getHarvestLevel();
            this.stats.harvestSpeed = this.getHarvestSpeed();
            this.stats.magicArmor = 0.0f;
            this.stats.magicDamage = this.getMagicDamage();
            this.stats.meleeDamage = this.getMeleeDamage();
            this.stats.rangedDamage = 0.0f;
            this.stats.rangedSpeed = 0.0f;
        }
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public ItemStack getCraftingStack() {
        return this.craftingStack;
    }

    @Nonnull
    public String getCraftingOreDictName() {
        return this.craftingOreDictName;
    }

    public EnumMaterialTier getTier() {
        return this.tier;
    }

    public int getRarity() {
        if (this.rarity > 0) {
            return this.rarity;
        }
        switch (this.getTier()) {
            case MUNDANE: {
                return 0;
            }
            case REGULAR: {
                return 40;
            }
            case SUPER: {
                return 60;
            }
        }
        return this.rarity;
    }

    public static TextFormatting getColorForRarity(int rarity) {
        if (rarity > 99) {
            return TextFormatting.AQUA;
        }
        if (rarity > 79) {
            return TextFormatting.GOLD;
        }
        if (rarity > 59) {
            return TextFormatting.DARK_PURPLE;
        }
        if (rarity > 39) {
            return TextFormatting.BLUE;
        }
        if (rarity > 19) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.WHITE;
    }

    @Deprecated
    public int getColor(ItemStack toolOrArmor) {
        return 0xFFFFFF;
    }

    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        return this.getColor(toolOrArmor);
    }

    public String getDisplayName(ItemStack partRep) {
        return partRep.func_82833_r();
    }

    public String getDisplayNamePrefix(ItemStack partRep) {
        return "";
    }

    public int getRepairAmount(ItemStack toolOrArmor, ItemStack partRep) {
        return 0;
    }

    public abstract ItemStatModifier getStatModifier(ItemStat var1, EnumMaterialGrade var2);

    public boolean matchesForCrafting(ItemStack partRep, boolean matchOreDict) {
        if (partRep.func_190926_b()) {
            return false;
        }
        if (partRep.func_77969_a(this.craftingStack)) {
            return true;
        }
        if (matchOreDict && !this.craftingOreDictName.isEmpty()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)partRep)) {
                if (!this.craftingOreDictName.equals(OreDictionary.getOreName((int)id))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesForDecorating(ItemStack partRep, boolean matchOreDict) {
        return this.matchesForCrafting(partRep, matchOreDict);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack toolOrArmor, ToolPartPosition pos) {
        return this.getModel(toolOrArmor, pos, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract ModelResourceLocation getModel(ItemStack var1, ToolPartPosition var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBrokenModel(ItemStack toolOrArmor, ToolPartPosition pos, int frame) {
        if (pos == ToolPartPosition.HEAD) {
            String name = toolOrArmor.func_77973_b().getRegistryName().func_110623_a();
            name = "silentgems:" + name + "/" + name + "_broken";
            return new ModelResourceLocation(name.toLowerCase(), "inventory");
        }
        if (pos == ToolPartPosition.TIP) {
            return ToolRenderHelper.getInstance().modelBlank;
        }
        return this.getModel(toolOrArmor, pos, frame);
    }

    public String getUnlocalizedName() {
        return this.key;
    }

    public List<EnumMaterialTier> getCompatibleTiers() {
        ArrayList list = Lists.newArrayList();
        for (EnumMaterialTier tier : EnumMaterialTier.values()) {
            if (!this.validForToolOfTier(tier)) continue;
            list.add(tier);
        }
        return list;
    }

    public boolean isBlacklisted(ItemStack partStack) {
        if (this.tier == EnumMaterialTier.MUNDANE && GemsConfig.PART_DISABLE_ALL_MUNDANE) {
            return true;
        }
        if (this.tier == EnumMaterialTier.REGULAR && GemsConfig.PART_DISABLE_ALL_REGULAR) {
            return true;
        }
        if (this.tier == EnumMaterialTier.SUPER && GemsConfig.PART_DISABLE_ALL_SUPER) {
            return true;
        }
        return GemsConfig.PART_BLACKLIST.contains(this.key);
    }

    @Deprecated
    public void applyStats(ToolStats stats) {
    }

    @Deprecated
    public abstract int getDurability();

    @Deprecated
    public abstract float getHarvestSpeed();

    @Deprecated
    public abstract int getHarvestLevel();

    @Deprecated
    public abstract float getMeleeDamage();

    @Deprecated
    public abstract float getMagicDamage();

    @Deprecated
    public abstract int getEnchantability();

    @Deprecated
    public abstract float getMeleeSpeed();

    @Deprecated
    public abstract float getChargeSpeed();

    @Deprecated
    public abstract float getProtection();

    public abstract boolean validForToolOfTier(EnumMaterialTier var1);

    public abstract boolean validForPosition(IPartPosition var1);

    public String toString() {
        String str = "ToolPart{";
        str = str + "Key: " + this.getKey() + ", ";
        str = str + "CraftingStack: " + this.getCraftingStack() + ", ";
        str = str + "CraftingOreDictName: '" + this.getCraftingOreDictName() + "', ";
        str = str + "Tier: " + (Object)((Object)this.getTier());
        str = str + "}";
        return str;
    }
}

