/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;

public abstract class ToolPartRod
extends ToolPart {
    protected float durabilityMulti = 1.0f;
    protected float harvestSpeedMulti = 1.0f;
    protected float meleeDamageMulti = 1.0f;
    protected float magicDamageMulti = 1.0f;
    protected float enchantabilityMulti = 1.0f;

    public ToolPartRod(String key, ItemStack craftingStack) {
        super(key, craftingStack);
    }

    public ToolPartRod(String key, ItemStack craftingStack, String oreName) {
        super(key, craftingStack, oreName);
    }

    public ToolPartRod(String key, ItemStack craftingStack, float durabilityMulti, float harvestSpeedMutli, float meleeDamageMulti, float magicDamageMulti, float enchantabilityMulti) {
        this(key, craftingStack);
        this.durabilityMulti = durabilityMulti;
        this.harvestSpeedMulti = harvestSpeedMutli;
        this.meleeDamageMulti = meleeDamageMulti;
        this.magicDamageMulti = magicDamageMulti;
        this.enchantabilityMulti = enchantabilityMulti;
    }

    public ToolPartRod(String key, ItemStack craftingStack, String oreName, float durabilityMulti, float harvestSpeedMutli, float meleeDamageMulti, float magicDamageMulti, float enchantabilityMulti) {
        this(key, craftingStack, oreName);
        this.durabilityMulti = durabilityMulti;
        this.harvestSpeedMulti = harvestSpeedMutli;
        this.meleeDamageMulti = meleeDamageMulti;
        this.magicDamageMulti = magicDamageMulti;
        this.enchantabilityMulti = enchantabilityMulti;
    }

    @Override
    public ItemStatModifier getStatModifier(ItemStat stat, EnumMaterialGrade grade) {
        float amount = 1.0f;
        if (stat == CommonItemStats.DURABILITY) {
            amount = this.durabilityMulti;
        } else if (stat == CommonItemStats.HARVEST_SPEED) {
            amount = this.harvestSpeedMulti;
        } else if (stat == CommonItemStats.MELEE_DAMAGE) {
            amount = this.meleeDamageMulti;
        } else if (stat == CommonItemStats.MAGIC_DAMAGE) {
            amount = this.magicDamageMulti;
        } else if (stat == CommonItemStats.ENCHANTABILITY) {
            amount = this.enchantabilityMulti;
        }
        return new ItemStatModifier(this.getUnlocalizedName(), amount, ItemStatModifier.Operation.MULTIPLY);
    }

    @Override
    public void applyStats(ToolStats stats) {
        stats.durability *= this.durabilityMulti;
        stats.harvestSpeed *= this.harvestSpeedMulti;
        stats.meleeDamage *= this.meleeDamageMulti;
        stats.magicDamage *= this.magicDamageMulti;
        stats.enchantability *= this.enchantabilityMulti;
    }

    @Override
    public int getDurability() {
        return 0;
    }

    @Override
    public float getHarvestSpeed() {
        return 0.0f;
    }

    @Override
    public int getHarvestLevel() {
        return 0;
    }

    @Override
    public float getMeleeDamage() {
        return 0.0f;
    }

    @Override
    public float getMagicDamage() {
        return 0.0f;
    }

    @Override
    public int getEnchantability() {
        return 0;
    }

    @Override
    public float getMeleeSpeed() {
        return 1.0f;
    }

    @Override
    public float getChargeSpeed() {
        return 0.0f;
    }

    @Override
    public final float getProtection() {
        return 0.0f;
    }

    @Override
    public boolean validForPosition(IPartPosition pos) {
        return pos == ToolPartPosition.ROD;
    }

    @Override
    public boolean validForToolOfTier(EnumMaterialTier toolTier) {
        switch (toolTier) {
            case MUNDANE: 
            case REGULAR: {
                return this.tier == EnumMaterialTier.MUNDANE || this.tier == EnumMaterialTier.REGULAR;
            }
            case SUPER: {
                return this.tier == EnumMaterialTier.REGULAR || this.tier == EnumMaterialTier.SUPER;
            }
        }
        return true;
    }

    public boolean supportsDecoration() {
        return this.tier.ordinal() >= EnumMaterialTier.SUPER.ordinal();
    }

    public Stats getStats() {
        return new Stats(this);
    }

    public static class Stats {
        public final float durabilityMulti;
        public final float harvestSpeedMulti;
        public final float meleeDamageMulti;
        public final float magicDamageMulti;
        public final float enchantabilityMulti;

        protected Stats(ToolPartRod part) {
            this.durabilityMulti = part.durabilityMulti;
            this.harvestSpeedMulti = part.harvestSpeedMulti;
            this.meleeDamageMulti = part.meleeDamageMulti;
            this.magicDamageMulti = part.magicDamageMulti;
            this.enchantabilityMulti = part.enchantabilityMulti;
        }

        public Stats(float durabilityMulti, float harvestSpeedMulti, float meleeDamageMulti, float magicDamageMulti, float enchantabilityMulti) {
            this.durabilityMulti = durabilityMulti;
            this.harvestSpeedMulti = harvestSpeedMulti;
            this.meleeDamageMulti = meleeDamageMulti;
            this.magicDamageMulti = magicDamageMulti;
            this.enchantabilityMulti = enchantabilityMulti;
        }
    }
}

