/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.silentchaos512.gems.client.gui.GuiTypes;
import net.silentchaos512.gems.lib.EnumPylonType;
import net.silentchaos512.gems.tile.TileChaosPylon;
import net.silentchaos512.lib.block.ITileEntityBlock;
import net.silentchaos512.lib.registry.ICustomModel;

public class BlockChaosPylon
extends BlockContainer
implements ITileEntityBlock,
ICustomModel {
    private static final PropertyEnum<VariantType> VARIANT = PropertyEnum.func_177709_a((String)"variant", VariantType.class);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);

    public BlockChaosPylon() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)VariantType.PASSIVE)));
        this.func_149715_a(0.25f);
        this.func_149713_g(0);
        this.func_149711_c(6.0f);
        this.func_149752_b(1000.0f);
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileChaosPylon.class;
    }

    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "silentgems:chaospylon";
        for (VariantType type : VariantType.values()) {
            ModelResourceLocation model = new ModelResourceLocation(fullName + type.ordinal(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)type.ordinal(), (ModelResourceLocation)model);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileChaosPylon toReturn = new TileChaosPylon();
        toReturn.setPylonType(EnumPylonType.getByMeta(meta));
        return toReturn;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumPylonType type = EnumPylonType.getByMeta(this.func_176201_c(state));
        if (world.field_72995_K) {
            return type == EnumPylonType.BURNER;
        }
        if (type == EnumPylonType.BURNER) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof TileChaosPylon) {
                GuiTypes.BURNER_PYLON.open(player, world, pos);
            }
            return true;
        }
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        Item item = Item.func_150898_a((Block)this);
        for (EnumPylonType type : EnumPylonType.values()) {
            if (type == EnumPylonType.NONE) continue;
            list.add((Object)new ItemStack(item, 1, type.getMeta()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)VariantType.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)VariantType.values().length)]));
    }

    public int func_176201_c(IBlockState state) {
        return ((VariantType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tilePylon = world.func_175625_s(pos);
        if (tilePylon instanceof TileChaosPylon) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileChaosPylon)tilePylon));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_180646_a(IBlockState worldIn, IBlockAccess pos, BlockPos state) {
        return super.func_180646_a(worldIn, pos, state);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public static enum VariantType implements IStringSerializable
    {
        PASSIVE,
        BURNER;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

