/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.lib.block.BlockMetaSubtypes;
import net.silentchaos512.lib.registry.ICustomModel;

public class BlockFluffyBlock
extends BlockMetaSubtypes
implements ICustomModel {
    private static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);

    public BlockFluffyBlock() {
        super(Material.field_151580_n, 16);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
        this.func_149711_c(0.8f);
        this.func_149752_b(3.0f);
        this.func_149672_a(SoundType.field_185854_g);
        this.setHarvestLevel("", 0);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float distance) {
        if (distance < 2.0f || world.field_72995_K) {
            return;
        }
        int stackedBlocks = 0;
        while (world.func_180495_p(pos).func_177230_c() == this) {
            pos = pos.func_177977_b();
            ++stackedBlocks;
        }
        distance -= Math.min((float)(10 * stackedBlocks), distance);
        entity.field_70143_R = 0.0f;
        entity.func_180430_e(distance, 1.0f);
    }

    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack mainHand = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (!mainHand.func_190926_b() && mainHand.func_77973_b() instanceof ItemShears) {
            int efficiency = EnchantmentHelper.func_185293_e((EntityLivingBase)event.getEntityPlayer());
            float speed = event.getNewSpeed() * 4.0f;
            if (efficiency > 0) {
                speed += (float)(efficiency * efficiency + 1);
            }
            event.setNewSpeed(speed);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "silentgems:fluffyblock";
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModelResourceLocation model = new ModelResourceLocation(fullName, "color=" + color.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)color.func_176765_a(), (ModelResourceLocation)model);
        }
    }
}

