/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockGemSubtypes;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.block.BlockMetaSubtypes;
import net.silentchaos512.lib.item.ItemBlockMetaSubtypes;
import net.silentchaos512.lib.registry.IAddRecipes;
import net.silentchaos512.wit.api.IWitHudInfo;
import org.apache.commons.lang3.NotImplementedException;

public class BlockGemLamp
extends BlockGemSubtypes
implements IAddRecipes,
IWitHudInfo {
    public final String nameForLocalization;
    public final boolean lit;
    public final boolean inverted;

    public BlockGemLamp(EnumGem.Set set, boolean lit, boolean inverted) {
        super(set, Material.field_151591_t);
        this.nameForLocalization = BlockGemLamp.nameForSet(set, "gemlamp");
        this.lit = lit;
        this.inverted = inverted;
        this.func_149711_c(0.3f);
        this.func_149752_b(10.0f);
        this.func_149715_a(lit ? 1.0f : 0.0f);
    }

    @Override
    String getBlockName() {
        return this.getBlockName(true);
    }

    private String getBlockName(boolean includeLampType) {
        if (includeLampType) {
            return BlockGemLamp.nameForSet(this.getGemSet(), "gemlamp" + (this.lit ? "Lit" : "") + (this.inverted ? "Inverted" : ""));
        }
        return BlockGemLamp.nameForSet(this.getGemSet(), "gemlamp");
    }

    public static BlockGemLamp getLamp(EnumGem.Set set, boolean lit, boolean inverted) {
        if (set == EnumGem.Set.CLASSIC) {
            if (lit) {
                if (inverted) {
                    return ModBlocks.gemLampLitInverted;
                }
                return ModBlocks.gemLampLit;
            }
            if (inverted) {
                return ModBlocks.gemLampInverted;
            }
            return ModBlocks.gemLamp;
        }
        if (set == EnumGem.Set.DARK) {
            if (lit) {
                if (inverted) {
                    return ModBlocks.gemLampLitInvertedDark;
                }
                return ModBlocks.gemLampLitDark;
            }
            if (inverted) {
                return ModBlocks.gemLampInvertedDark;
            }
            return ModBlocks.gemLampDark;
        }
        if (set == EnumGem.Set.LIGHT) {
            if (lit) {
                if (inverted) {
                    return ModBlocks.gemLampLitInvertedLight;
                }
                return ModBlocks.gemLampLitLight;
            }
            if (inverted) {
                return ModBlocks.gemLampInvertedLight;
            }
            return ModBlocks.gemLampLight;
        }
        throw new NotImplementedException("Gem set \"" + (Object)((Object)set) + "\" is not recognized!");
    }

    public BlockGemLamp getLamp(boolean isLit) {
        return BlockGemLamp.getLamp(this.getGemSet(), isLit, this.inverted);
    }

    private void setState(World world, BlockPos pos, BlockGemLamp block, EnumGem gem) {
        world.func_180501_a(pos, block.func_176223_P().func_177226_a(EnumGem.VARIANT_GEM, (Comparable)((Object)gem)), 2);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            boolean powered = world.func_175640_z(pos);
            EnumGem gem = EnumGem.values()[this.func_176201_c(state)];
            this.setState(world, pos, this.getLamp(this.inverted != powered), gem);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            boolean powered = world.func_175640_z(pos);
            EnumGem gem = EnumGem.values()[this.func_176201_c(state)];
            BlockGemLamp newBlock = this.getLamp(this.inverted != powered);
            if (this.inverted) {
                if (!this.lit && !powered) {
                    world.func_175684_a(pos, (Block)this, 4);
                } else if (this.lit && powered) {
                    this.setState(world, pos, newBlock, gem);
                }
            } else if (this.lit && !powered) {
                world.func_175684_a(pos, (Block)this, 4);
            } else if (!this.lit && powered) {
                this.setState(world, pos, newBlock, gem);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        boolean powered;
        if (!world.field_72995_K && !(powered = world.func_175640_z(pos))) {
            EnumGem gem = EnumGem.values()[this.func_176201_c(state)];
            this.setState(world, pos, this.getLamp(this.inverted != powered), gem);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        BlockGemLamp block = BlockGemLamp.getLamp(this.getGemSet(), this.inverted, this.inverted);
        return Item.func_150898_a((Block)block);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(this.func_180660_a(state, SilentGems.random, 0));
    }

    public void func_190948_a(ItemStack stack, World world, List<String> list, ITooltipFlag flag) {
        if (this.inverted) {
            list.add(SilentGems.i18n.blockSubText("gemlamp", "inverted", new Object[0]));
        }
    }

    @Override
    public List<String> getWitLines(IBlockState state, BlockPos pos, EntityPlayer player, boolean advanced) {
        String line = this.inverted ? SilentGems.i18n.blockSubText("gemlamp", "inverted", new Object[0]) : "";
        line = line + (this.lit ? (line.isEmpty() ? "" : ", ") + SilentGems.i18n.blockSubText("gemlamp", "lit", new Object[0]) : "");
        return line.isEmpty() ? null : Lists.newArrayList((Object[])new String[]{line});
    }

    public static class ItemBlock
    extends ItemBlockMetaSubtypes {
        public ItemBlock(BlockGemLamp block) {
            super((BlockMetaSubtypes)block);
        }

        @Nonnull
        public String func_77653_i(@Nonnull ItemStack stack) {
            BlockGemLamp block = (BlockGemLamp)Block.func_149634_a((Item)stack.func_77973_b());
            String suffix = block.inverted ? " (" + SilentGems.i18n.translate("tile.silentgems.gemlamp.inverted", new Object[0]) + ")" : "";
            return super.func_77653_i(stack) + suffix;
        }

        @Nonnull
        public String func_77667_c(ItemStack stack) {
            return "tile.silentgems." + ((BlockGemLamp)this.field_150939_a).getBlockName(false) + (stack.func_77952_i() & 0xF);
        }
    }
}

