/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.lib.block.BlockMetaSubtypes;
import net.silentchaos512.lib.item.ItemBlockMetaSubtypes;
import net.silentchaos512.lib.registry.ICustomModel;

public class BlockMisc
extends BlockMetaSubtypes
implements ICustomModel {
    private static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockMisc() {
        super(Material.field_151573_f, Type.values().length);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.CHAOS_ESSENCE)));
    }

    public ItemStack getStack(Type type, int count) {
        return new ItemStack((Block)this, count, type.ordinal());
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState enderBlock = this.func_176203_a(Type.ENDER_ESSENCE.ordinal());
        if (entityIn instanceof EntityLivingBase && worldIn.func_180495_p(pos) == enderBlock) {
            int stackedBlocks = 1;
            IBlockState state = worldIn.func_180495_p(pos.func_177979_c(stackedBlocks));
            while (state == enderBlock && stackedBlocks < 5) {
                state = worldIn.func_180495_p(pos.func_177979_c(++stackedBlocks));
            }
            ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, stackedBlocks - 1));
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(Type.values().length - 1));
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void registerModels() {
        Item item = Item.func_150898_a((Block)this);
        String fullName = "silentgems:miscblock";
        for (Type type : Type.values()) {
            ModelResourceLocation model = new ModelResourceLocation(fullName, "type=" + type.func_176610_l());
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)type.ordinal(), (ModelResourceLocation)model);
        }
    }

    public static class ItemBlock
    extends ItemBlockMetaSubtypes {
        public ItemBlock(BlockMisc block) {
            super((BlockMetaSubtypes)block);
        }

        public int getItemBurnTime(ItemStack itemStack) {
            if (itemStack.func_77973_b() == this && itemStack.func_77952_i() == Type.CHAOS_COAL.ordinal()) {
                return 10 * GemsConfig.BURN_TIME_CHAOS_COAL;
            }
            return 0;
        }

        public EnumRarity func_77613_e(ItemStack stack) {
            switch (Type.values()[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(Type.values().length - 1))]) {
                case CHAOS_ESSENCE_CRYSTALLIZED: {
                    return EnumRarity.EPIC;
                }
                case CHAOS_ESSENCE_ENRICHED: {
                    return EnumRarity.RARE;
                }
            }
            return EnumRarity.COMMON;
        }
    }

    public static enum Type implements IStringSerializable
    {
        CHAOS_ESSENCE,
        CHAOS_ESSENCE_ENRICHED,
        CHAOS_ESSENCE_CRYSTALLIZED,
        CHAOS_COAL,
        CHAOS_IRON,
        ENDER_ESSENCE;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getMetadata() {
            return this.ordinal();
        }
    }
}

