/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block.supercharger;

import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.block.BlockMisc;
import net.silentchaos512.gems.compat.gear.SGearProxy;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModEnchantments;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.TimeHelper;

public class TileSupercharger
extends TileSidedInventorySL
implements ITickable,
IChaosAccepter {
    static final int MAX_CHAOS_STORED = 1000000;
    private static final int INVENTORY_SIZE = 3;
    private static final int UPDATE_FREQUENCY = TimeHelper.ticksFromSeconds((float)15.0f);
    @SyncVariable(name="Energy")
    private int chaosStored;
    @SyncVariable(name="Progress")
    private int progress;
    @SyncVariable(name="StructureLevel")
    private int structureLevel;
    private int updateTimer = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.updateTimer;
        if (this.updateTimer > UPDATE_FREQUENCY) {
            if (this.checkStructureLevel()) {
                SilentGems.logHelper.info("Supercharger at {}: structure level updated to {}", new Object[]{this.field_174879_c, this.structureLevel});
            }
            this.sendUpdate();
            this.updateTimer = 0;
        }
        ItemStack input = this.getInputItem();
        ItemStack catalyst = this.getCatalystItem();
        if (!input.func_190926_b() && !catalyst.func_190926_b()) {
            this.handleCharging(input, catalyst);
        } else {
            this.progress = 0;
        }
    }

    private void handleCharging(ItemStack input, ItemStack catalyst) {
        int chargeTier = ModItems.chargingAgent.getTier(catalyst);
        if (chargeTier > 0 && chargeTier <= this.structureLevel) {
            int totalCost = this.getChaosCostForCharging();
            int chaosDrained = MathUtils.min((int)this.chaosStored, (int)this.getChaosDrainPerTick(), (int)(totalCost - this.progress));
            if (this.wouldFitInOutputSlot(input, chargeTier)) {
                if (chaosDrained > 0) {
                    this.chaosStored -= chaosDrained;
                    this.progress += chaosDrained;
                }
                if (this.progress >= totalCost) {
                    if (this.func_70301_a(2).func_190926_b()) {
                        ItemStack output = input.func_77946_l();
                        output.func_190920_e(1);
                        output.func_77966_a((Enchantment)ModEnchantments.supercharged, chargeTier);
                        this.func_70299_a(2, output);
                    } else {
                        this.func_70301_a(2).func_190917_f(1);
                    }
                    this.progress = 0;
                    this.func_70298_a(0, 1);
                    this.func_70298_a(1, 1);
                }
                if (chaosDrained > 0) {
                    this.sendUpdate();
                }
            }
        }
    }

    private ItemStack getInputItem() {
        ItemStack stack = this.func_70301_a(0);
        return SGearProxy.isMainPart(stack) ? stack : ItemStack.field_190927_a;
    }

    private ItemStack getCatalystItem() {
        ItemStack stack = this.func_70301_a(1);
        return stack.func_77973_b() == ModItems.chargingAgent ? stack : ItemStack.field_190927_a;
    }

    private boolean checkStructureLevel() {
        int oldValue = this.structureLevel;
        this.structureLevel = MathUtils.min((int)this.getPillarLevel(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3).func_177967_a(EnumFacing.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(EnumFacing.NORTH, 3).func_177967_a(EnumFacing.EAST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3).func_177967_a(EnumFacing.WEST, 3)), (int)this.getPillarLevel(this.field_174879_c.func_177967_a(EnumFacing.SOUTH, 3).func_177967_a(EnumFacing.EAST, 3)));
        return this.structureLevel != oldValue;
    }

    private int getPillarLevel(BlockPos pos) {
        IBlockState state1 = this.field_145850_b.func_180495_p(pos);
        IBlockState state2 = this.field_145850_b.func_180495_p(pos.func_177984_a());
        if (TileSupercharger.isMiscBlock(state1, BlockMisc.Type.CHAOS_IRON) && TileSupercharger.isGemBlock(state2)) {
            return 1;
        }
        IBlockState state3 = this.field_145850_b.func_180495_p(pos.func_177981_b(2));
        if (TileSupercharger.isMiscBlock(state1, BlockMisc.Type.CHAOS_ESSENCE_ENRICHED) && TileSupercharger.isMiscBlock(state2, BlockMisc.Type.CHAOS_IRON) && TileSupercharger.isGemBlock(state3)) {
            return 2;
        }
        IBlockState state4 = this.field_145850_b.func_180495_p(pos.func_177981_b(3));
        IBlockState state5 = this.field_145850_b.func_180495_p(pos.func_177981_b(4));
        if (TileSupercharger.isMiscBlock(state1, BlockMisc.Type.ENDER_ESSENCE) && TileSupercharger.isMiscBlock(state2, BlockMisc.Type.ENDER_ESSENCE) && TileSupercharger.isMiscBlock(state3, BlockMisc.Type.CHAOS_ESSENCE_ENRICHED) && TileSupercharger.isMiscBlock(state4, BlockMisc.Type.CHAOS_IRON) && TileSupercharger.isGemBlock(state5)) {
            return 3;
        }
        return 0;
    }

    private static boolean isGemBlock(IBlockState state) {
        return state.func_177230_c() == ModBlocks.gemBlock || state.func_177230_c() == ModBlocks.gemBlockDark || state.func_177230_c() == ModBlocks.gemBlockLight;
    }

    private static boolean isMiscBlock(IBlockState state, BlockMisc.Type type) {
        return state.func_177230_c() == ModBlocks.miscBlock && state.func_177230_c().func_176201_c(state) == type.getMetadata();
    }

    private boolean wouldFitInOutputSlot(ItemStack input, int chargeTier) {
        ItemStack output = this.func_70301_a(2);
        if (output.func_190926_b()) {
            return true;
        }
        return output.func_190916_E() < output.func_77976_d() && input.func_77969_a(output) && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.supercharged, (ItemStack)output) == chargeTier && SGearProxy.getGradeString(input).equalsIgnoreCase(SGearProxy.getGradeString(output));
    }

    int getChaosCostForCharging() {
        return TileSupercharger.getChaosCostForCharging(this.getInputItem(), this.getCatalystItem());
    }

    private static int getChaosCostForCharging(ItemStack gearPart, ItemStack catalyst) {
        if (gearPart.func_190926_b() || catalyst.func_190926_b()) {
            return -1;
        }
        int tier = SGearProxy.getPartTier(gearPart);
        int chargeTier = ModItems.chargingAgent.getTier(catalyst);
        return tier >= 0 && chargeTier > 0 ? chargeTier * (chargeTier + 1) * (int)Math.pow(10.0, tier + 1) : -1;
    }

    int getChaosDrainPerTick() {
        int partTier = SGearProxy.getPartTier(this.getInputItem());
        int chargeTier = ModItems.chargingAgent.getTier(this.getCatalystItem());
        if (partTier < 0 || chargeTier <= 0) {
            return 0;
        }
        int rate = TileSupercharger.getChaosDrainPerTick(partTier, chargeTier);
        return Math.min(rate, this.getChaosCostForCharging() / 20);
    }

    private static int getChaosDrainPerTick(int partTier, int chargeTier) {
        if (chargeTier < 1) {
            return 0;
        }
        return (int)((double)(2 * chargeTier) * Math.pow(5.0, partTier));
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return SGearProxy.isMainPart(stack);
        }
        if (index == 1) {
            return stack.func_77973_b() == ModItems.chargingAgent;
        }
        return false;
    }

    @Override
    public int receiveCharge(int maxReceive, boolean simulate) {
        int received = Math.min(1000000 - this.chaosStored, maxReceive);
        if (!simulate) {
            this.chaosStored += received;
            if (received != 0) {
                this.sendUpdate();
            }
        }
        return received;
    }

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return 1000000;
    }

    public int func_70302_i_() {
        return 3;
    }

    public int func_174890_g() {
        return 2;
    }

    public int func_174887_a_(int id) {
        if (id == 0) {
            return this.chaosStored;
        }
        if (id == 1) {
            return this.progress;
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.chaosStored = value;
        }
        if (id == 1) {
            this.progress = value;
        }
    }
}

